/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         This elements describes all that pertains to
 * distribution for a project.
 *         It is primarily used for deployment of artifacts and
 * distributions 
 *         produced by the build.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class DistributionManagement implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field repository
     */
    private DeploymentRepository repository;

    /**
     * Field snapshotRepository
     */
    private DeploymentRepository snapshotRepository;

    /**
     * Field site
     */
    private Site site;

    /**
     * Field downloadUrl
     */
    private String downloadUrl;

    /**
     * Field relocation
     */
    private Relocation relocation;

    /**
     * Field status
     */
    private String status;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The URL of the project's download page. If not
     * given users will be referred to the homepage given by
     *             <code>url</code>.
     *           
     */
    public String getDownloadUrl()
    {
        return this.downloadUrl;
    } //-- String getDownloadUrl() 

    /**
     * Get Relocation information if the artifact has been moved to
     * a new group/artifactId
     */
    public Relocation getRelocation()
    {
        return this.relocation;
    } //-- Relocation getRelocation() 

    /**
     * Get 
     *             Information needed for deploying to remote
     * repository artifacts
     *             generated by the project
     *           
     */
    public DeploymentRepository getRepository()
    {
        return this.repository;
    } //-- DeploymentRepository getRepository() 

    /**
     * Get 
     *             Information needed for deploying website files
     * of the project.
     *           
     */
    public Site getSite()
    {
        return this.site;
    } //-- Site getSite() 

    /**
     * Get 
     *             Where to deploy snapshots of artifacts to. If
     * not given, it defaults to the repository.
     *           
     */
    public DeploymentRepository getSnapshotRepository()
    {
        return this.snapshotRepository;
    } //-- DeploymentRepository getSnapshotRepository() 

    /**
     * Get 
     *             Gives the status of this artifact in the remote
     * repository. This must not be set in your local
     *             project, as it is updated by tools placing it in
     * the reposiory. Valid values are: none (default),
     *             converted (repository manager converted this
     * from an Maven 1 POM), partner (directly synced from a
     * partner
     *             Maven 2 repository), deployed (was deployed from
     * a Maven 2 instance), verified (has been hand verified as
     *             correct and final).
     *           
     */
    public String getStatus()
    {
        return this.status;
    } //-- String getStatus() 

    /**
     * Set 
     *             The URL of the project's download page. If not
     * given users will be referred to the homepage given by
     *             <code>url</code>.
     *           
     * 
     * @param downloadUrl
     */
    public void setDownloadUrl(String downloadUrl)
    {
        this.downloadUrl = downloadUrl;
    } //-- void setDownloadUrl(String) 

    /**
     * Set Relocation information if the artifact has been moved to
     * a new group/artifactId
     * 
     * @param relocation
     */
    public void setRelocation(Relocation relocation)
    {
        this.relocation = relocation;
    } //-- void setRelocation(Relocation) 

    /**
     * Set 
     *             Information needed for deploying to remote
     * repository artifacts
     *             generated by the project
     *           
     * 
     * @param repository
     */
    public void setRepository(DeploymentRepository repository)
    {
        this.repository = repository;
    } //-- void setRepository(DeploymentRepository) 

    /**
     * Set 
     *             Information needed for deploying website files
     * of the project.
     *           
     * 
     * @param site
     */
    public void setSite(Site site)
    {
        this.site = site;
    } //-- void setSite(Site) 

    /**
     * Set 
     *             Where to deploy snapshots of artifacts to. If
     * not given, it defaults to the repository.
     *           
     * 
     * @param snapshotRepository
     */
    public void setSnapshotRepository(DeploymentRepository snapshotRepository)
    {
        this.snapshotRepository = snapshotRepository;
    } //-- void setSnapshotRepository(DeploymentRepository) 

    /**
     * Set 
     *             Gives the status of this artifact in the remote
     * repository. This must not be set in your local
     *             project, as it is updated by tools placing it in
     * the reposiory. Valid values are: none (default),
     *             converted (repository manager converted this
     * from an Maven 1 POM), partner (directly synced from a
     * partner
     *             Maven 2 repository), deployed (was deployed from
     * a Maven 2 instance), verified (has been hand verified as
     *             correct and final).
     *           
     * 
     * @param status
     */
    public void setStatus(String status)
    {
        this.status = status;
    } //-- void setStatus(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
