/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * 
 *         This element describes all of the resources associated
 * with a project or 
 *         unit tests. Each resource is described by a resource
 * element, which is 
 *         then described by additional elements (described 
 *         <a href="#resource">below</a>). These resources are used
 * to complete the 
 *         jar file or to run unit test.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Resource extends FileSet 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field targetPath
     */
    private String targetPath;

    /**
     * Field filtering
     */
    private boolean filtering = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             Describe the resource target path. For example,
     * if you want that 
     *             resource appear into a specific package 
     *             (<code>org.apache.maven.messages</code>), you
     * must specify this 
     *             element with this value :
     * <code>org/apache/maven/messages</code>
     *           
     */
    public String getTargetPath()
    {
        return this.targetPath;
    } //-- String getTargetPath() 

    /**
     * Get Boolean. Describe if resources are filtered or not.
     */
    public boolean isFiltering()
    {
        return this.filtering;
    } //-- boolean isFiltering() 

    /**
     * Set Boolean. Describe if resources are filtered or not.
     * 
     * @param filtering
     */
    public void setFiltering(boolean filtering)
    {
        this.filtering = filtering;
    } //-- void setFiltering(boolean) 

    /**
     * Set 
     *             Describe the resource target path. For example,
     * if you want that 
     *             resource appear into a specific package 
     *             (<code>org.apache.maven.messages</code>), you
     * must specify this 
     *             element with this value :
     * <code>org/apache/maven/messages</code>
     *           
     * 
     * @param targetPath
     */
    public void setTargetPath(String targetPath)
    {
        this.targetPath = targetPath;
    } //-- void setTargetPath(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
