/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.registry;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.registry.Plugin;
import org.apache.maven.plugin.registry.RuntimeInfo;
import org.apache.maven.plugin.registry.TrackableBase;

public class PluginRegistry
extends TrackableBase
implements Serializable {
    private String updateInterval = "never";
    private String autoUpdate;
    private List plugins;
    private Map pluginsByKey;
    private RuntimeInfo runtimeInfo;

    public void addPlugin(Plugin plugin) {
        this.getPlugins().add(plugin);
    }

    public String getAutoUpdate() {
        return this.autoUpdate;
    }

    public List getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList();
        }
        return this.plugins;
    }

    public String getUpdateInterval() {
        return this.updateInterval;
    }

    public void removePlugin(Plugin plugin) {
        this.getPlugins().remove(plugin);
    }

    public void setAutoUpdate(String autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public void setPlugins(List plugins) {
        this.plugins = plugins;
    }

    public void setUpdateInterval(String updateInterval) {
        this.updateInterval = updateInterval;
    }

    public Map getPluginsByKey() {
        if (this.pluginsByKey == null) {
            this.pluginsByKey = new HashMap();
            Iterator it = this.getPlugins().iterator();
            while (it.hasNext()) {
                Plugin plugin = (Plugin)it.next();
                this.pluginsByKey.put(plugin.getKey(), plugin);
            }
        }
        return this.pluginsByKey;
    }

    public void flushPluginsByKey() {
        this.pluginsByKey = null;
    }

    public void setRuntimeInfo(RuntimeInfo runtimeInfo) {
        this.runtimeInfo = runtimeInfo;
    }

    public RuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }
}

