/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.beanshell;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;

public class BeanshellMojoDescriptorExtractor
extends AbstractLogEnabled
implements MojoDescriptorExtractor {
    private MojoDescriptor createMojoDescriptor(File basedir, String resource, PluginDescriptor pluginDescriptor) throws InvalidPluginDescriptorException {
        MojoDescriptor mojoDescriptor = new MojoDescriptor();
        mojoDescriptor.setPluginDescriptor(pluginDescriptor);
        mojoDescriptor.setLanguage("bsh");
        mojoDescriptor.setComponentConfigurator("bsh");
        mojoDescriptor.setImplementation(resource);
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("file", (Object)new File(basedir, resource));
            interpreter.set("mojoDescriptor", (Object)mojoDescriptor);
            interpreter.eval((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/extractor.bsh")));
        }
        catch (EvalError evalError) {
            throw new InvalidPluginDescriptorException("Error scanning beanshell script", (Throwable)evalError);
        }
        return mojoDescriptor;
    }

    public List execute(MavenProject project, PluginDescriptor pluginDescriptor) throws InvalidPluginDescriptorException {
        ArrayList<MojoDescriptor> descriptors = new ArrayList<MojoDescriptor>();
        Iterator i = project.getScriptSourceRoots().iterator();
        while (i.hasNext()) {
            try {
                File basedir = new File((String)i.next());
                if (!basedir.exists()) continue;
                List files = FileUtils.getFiles((File)basedir, (String)"**/*.bsh", null, (boolean)false);
                Iterator j = files.iterator();
                while (j.hasNext()) {
                    File resource = (File)j.next();
                    String resourcePath = "/" + resource.getPath().replace('\\', '/');
                    MojoDescriptor mojoDescriptor = this.createMojoDescriptor(basedir, resourcePath, pluginDescriptor);
                    descriptors.add(mojoDescriptor);
                }
            }
            catch (IOException e) {
                throw new InvalidPluginDescriptorException("Unable to locate files to process", (Throwable)e);
            }
        }
        return descriptors;
    }
}

