/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Repository;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public final class ProjectUtils {
    private ProjectUtils() {
    }

    public static List buildArtifactRepositories(List repositories, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer container) throws ProjectBuildingException {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        Iterator i = repositories.iterator();
        while (i.hasNext()) {
            Repository mavenRepo = (Repository)i.next();
            ArtifactRepository artifactRepo = ProjectUtils.buildArtifactRepository(mavenRepo, artifactRepositoryFactory, container);
            if (repos.contains(artifactRepo)) continue;
            repos.add(artifactRepo);
        }
        return repos;
    }

    public static ArtifactRepository buildArtifactRepository(Repository repo, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer container) throws ProjectBuildingException {
        if (repo != null) {
            String id = repo.getId();
            String url = repo.getUrl();
            String snapshotPolicy = repo.getSnapshotPolicy();
            String checksumPolicy = repo.getChecksumPolicy();
            ArtifactRepositoryLayout layout = ProjectUtils.getRepositoryLayout(repo, container);
            return artifactRepositoryFactory.createArtifactRepository(id, url, layout, snapshotPolicy, checksumPolicy);
        }
        return null;
    }

    private static ArtifactRepositoryLayout getRepositoryLayout(Repository mavenRepo, PlexusContainer container) throws ProjectBuildingException {
        String layout = mavenRepo.getLayout();
        ArtifactRepositoryLayout repositoryLayout = null;
        try {
            repositoryLayout = (ArtifactRepositoryLayout)container.lookup(ArtifactRepositoryLayout.ROLE, layout);
        }
        catch (ComponentLookupException e) {
            throw new ProjectBuildingException("Cannot find layout implementation corresponding to: '" + layout + "' for remote repository with id: '" + mavenRepo.getId() + "'.", e);
        }
        return repositoryLayout;
    }
}

