/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.interpolation;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class RegexBasedModelInterpolator
extends AbstractLogEnabled
implements ModelInterpolator {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(pom\\.|project\\.)?([^}]+)\\}");

    public Model interpolate(Model model) throws ModelInterpolationException {
        StringWriter sWriter = new StringWriter();
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try {
            writer.write((Writer)sWriter, model);
        }
        catch (IOException e) {
            throw new ModelInterpolationException("Cannot serialize project model for interpolation.", e);
        }
        String serializedModel = sWriter.toString();
        serializedModel = this.interpolateInternal(serializedModel, model);
        StringReader sReader = new StringReader(serializedModel);
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        try {
            model = modelReader.read((Reader)sReader);
        }
        catch (IOException e) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e);
        }
        catch (XmlPullParserException e) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e);
        }
        return model;
    }

    private String interpolateInternal(String src, Model model) {
        String result = src;
        Matcher matcher = EXPRESSION_PATTERN.matcher(result);
        while (matcher.find()) {
            Object value;
            String wholeExpr;
            block3: {
                wholeExpr = matcher.group(0);
                String realExpr = matcher.group(2);
                value = null;
                try {
                    value = ReflectionValueExtractor.evaluate((String)realExpr, (Object)model);
                }
                catch (Exception e) {
                    Logger logger = this.getLogger();
                    if (logger == null) break block3;
                    logger.debug("POM interpolation cannot proceed with expression: " + wholeExpr + ". Skipping...", (Throwable)e);
                }
            }
            if (value == null) continue;
            result = StringUtils.replace((String)result, (String)wholeExpr, (String)String.valueOf(value));
            matcher.reset(result);
        }
        return result;
    }
}

