/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.path;

import java.io.File;
import java.util.Iterator;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.project.path.PathTranslator;

public class DefaultPathTranslator
implements PathTranslator {
    private String FILE_SEPARATOR = "/";

    public void alignToBaseDirectory(Model model, File projectFile) {
        Build build = model.getBuild();
        File basedir = projectFile.getParentFile();
        if (build != null) {
            Resource resource;
            build.setDirectory(this.alignToBaseDirectory(build.getDirectory(), basedir));
            build.setSourceDirectory(this.alignToBaseDirectory(build.getSourceDirectory(), basedir));
            build.setTestSourceDirectory(this.alignToBaseDirectory(build.getTestSourceDirectory(), basedir));
            Iterator i = build.getResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
            }
            i = build.getTestResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
            }
            build.setOutputDirectory(this.alignToBaseDirectory(build.getOutputDirectory(), basedir));
            build.setTestOutputDirectory(this.alignToBaseDirectory(build.getTestOutputDirectory(), basedir));
        }
    }

    public String alignToBaseDirectory(String path, File basedir) {
        String s = this.stripBasedirToken(path);
        if (this.requiresBaseDirectoryAlignment(s)) {
            s = new File(basedir, s).getPath();
        }
        return s;
    }

    private String stripBasedirToken(String s) {
        if (s != null && (s = s.trim()).startsWith("${basedir}")) {
            s = s.substring(11);
        }
        return s;
    }

    private boolean requiresBaseDirectoryAlignment(String s) {
        if (s != null) {
            File f = new File(s);
            return !s.startsWith(this.FILE_SEPARATOR) && !f.isAbsolute();
        }
        return false;
    }
}

