/*
 * $Id$
 */

package org.apache.maven.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         common base class that contains code to track the source
 * for
 *         this instance (USER|GLOBAL)
 *       .
 * 
 * @version $Revision$ $Date$
 */
public class TrackableBase implements java.io.Serializable {


            
    public static final String USER_LEVEL = "user-level";
    public static final String GLOBAL_LEVEL = "global-level";

    private String sourceLevel = USER_LEVEL;
    private boolean sourceLevelSet = false;

    public void setSourceLevel( String sourceLevel )
    {
        if ( sourceLevelSet )
        {
            throw new IllegalStateException( "Cannot reset sourceLevel attribute; it is already set to: " + sourceLevel );
        }
        else if ( !( USER_LEVEL.equals( sourceLevel ) || GLOBAL_LEVEL.equals( sourceLevel ) ) )
        {
            throw new IllegalArgumentException( "sourceLevel must be one of: {" + USER_LEVEL + "," + GLOBAL_LEVEL + "}" );
        }
        else
        {
            this.sourceLevel = sourceLevel;
            this.sourceLevelSet = true;
        }
    }

    public String getSourceLevel()
    {
        return sourceLevel;
    }
            
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
