/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.mercury.artifact.ArtifactCoordinates;
import org.apache.maven.mercury.artifact.ArtifactScopeEnum;
import org.apache.maven.mercury.artifact.version.VersionException;
import org.apache.maven.mercury.artifact.version.VersionRange;
import org.apache.maven.mercury.artifact.version.VersionRangeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactBasicMetadata {
    public static final String DEFAULT_ARTIFACT_TYPE = "jar";
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected List<ArtifactCoordinates> relocations;
    protected ArtifactCoordinates effectiveCoordinates;
    protected String classifier;
    protected String type = "jar";
    protected ArtifactScopeEnum artifactScope;
    protected String scope;
    protected boolean optional;
    protected Collection<ArtifactBasicMetadata> inclusions;
    protected Collection<ArtifactBasicMetadata> exclusions;
    transient Object tracker;
    transient Boolean local = false;

    public ArtifactBasicMetadata() {
    }

    public ArtifactBasicMetadata(String query) {
        if (query == null) {
            return;
        }
        String[] tokens = query.split(":");
        if (tokens == null || tokens.length < 1) {
            return;
        }
        int count = tokens.length;
        this.groupId = ArtifactBasicMetadata.nullify(tokens[0]);
        if (count > 1) {
            this.artifactId = ArtifactBasicMetadata.nullify(tokens[1]);
        }
        if (count > 2) {
            this.version = ArtifactBasicMetadata.nullify(tokens[2]);
        }
        if (count > 3) {
            this.classifier = ArtifactBasicMetadata.nullify(tokens[3]);
        }
        if (count > 4) {
            this.type = ArtifactBasicMetadata.nullify(tokens[4]);
        }
        if (this.type == null || this.type.length() < 1) {
            this.type = DEFAULT_ARTIFACT_TYPE;
        }
    }

    public static ArtifactBasicMetadata create(String query) {
        ArtifactBasicMetadata mdq = new ArtifactBasicMetadata(query);
        return mdq;
    }

    private static final String nullify(String s) {
        if (s == null || s.length() < 1) {
            return null;
        }
        return s;
    }

    public boolean sameGAV(ArtifactBasicMetadata md) {
        if (md == null) {
            return false;
        }
        return this.sameGA(md) && this.version != null && this.version.equals(md.getVersion());
    }

    public boolean sameGA(ArtifactBasicMetadata md) {
        if (md == null) {
            return false;
        }
        return this.groupId != null && this.artifactId != null && this.groupId.equals(md.getGroupId()) && this.artifactId.equals(md.getArtifactId());
    }

    public String getGA() {
        return this.toDomainString();
    }

    public String getGAV() {
        return this.toString();
    }

    private static final String nvl(String val, String dflt) {
        return val == null ? dflt : val;
    }

    private static final String nvl(String val) {
        return ArtifactBasicMetadata.nvl(val, "");
    }

    public String toString() {
        return ArtifactBasicMetadata.nvl(this.groupId) + ":" + ArtifactBasicMetadata.nvl(this.artifactId) + ":" + ArtifactBasicMetadata.nvl(this.version) + ":" + ArtifactBasicMetadata.nvl(this.classifier) + ":" + ArtifactBasicMetadata.nvl(this.type, DEFAULT_ARTIFACT_TYPE);
    }

    public String toScopedString() {
        return this.toString() + "-scope:" + (Object)((Object)this.getArtifactScope());
    }

    public String toDomainString() {
        return this.groupId + ":" + this.artifactId;
    }

    public String getBaseName() {
        return this.artifactId + "-" + this.version + (this.classifier == null ? "" : "-" + this.classifier);
    }

    public String getBaseName(String classifier) {
        return this.artifactId + "-" + this.version + (classifier == null || classifier.length() < 1 ? "" : "-" + classifier);
    }

    public String getCheckedType() {
        return this.type == null ? DEFAULT_ARTIFACT_TYPE : this.type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasVersion() {
        return this.version != null && this.version.length() > 0;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getScope() {
        return this.getArtifactScope().getScope();
    }

    public ArtifactScopeEnum getScopeAsEnum() {
        return this.artifactScope == null ? ArtifactScopeEnum.DEFAULT_SCOPE : this.artifactScope;
    }

    public ArtifactScopeEnum getArtifactScope() {
        return this.artifactScope == null ? ArtifactScopeEnum.DEFAULT_SCOPE : this.artifactScope;
    }

    public void setArtifactScope(ArtifactScopeEnum artifactScope) {
        this.artifactScope = artifactScope;
    }

    public void setScope(String scope) {
        this.artifactScope = scope == null ? ArtifactScopeEnum.DEFAULT_SCOPE : ArtifactScopeEnum.valueOf(scope);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setOptional(String optional) {
        this.optional = "true".equals(optional);
    }

    public Object getTracker() {
        return this.tracker;
    }

    public void setTracker(Object tracker) {
        this.tracker = tracker;
    }

    public boolean hasClassifier() {
        return this.classifier != null && this.classifier.length() > 0;
    }

    public Boolean isLocal() {
        return this.local;
    }

    public void setLocal(Boolean local) {
        this.local = local;
    }

    public ArtifactCoordinates getEffectiveCoordinates() {
        if (this.relocations == null || this.relocations.isEmpty()) {
            return new ArtifactCoordinates(this.groupId, this.artifactId, this.version);
        }
        return this.relocations.get(this.relocations.size() - 1);
    }

    public ArtifactBasicMetadata addRelocation(ArtifactCoordinates coord) {
        if (coord == null) {
            return this;
        }
        if (this.relocations == null) {
            this.relocations = new ArrayList<ArtifactCoordinates>(2);
        }
        if (coord.getGroupId() == null) {
            coord.setGroupId(this.groupId);
        }
        if (coord.getArtifactId() == null) {
            coord.setArtifactId(this.artifactId);
        }
        if (coord.getVersion() == null) {
            coord.setVersion(this.version);
        }
        this.relocations.add(coord);
        this.effectiveCoordinates = coord;
        return this;
    }

    public String getEffectiveGroupId() {
        return this.effectiveCoordinates == null ? this.groupId : this.effectiveCoordinates.getGroupId();
    }

    public String getEffectiveArtifactId() {
        return this.effectiveCoordinates == null ? this.artifactId : this.effectiveCoordinates.getArtifactId();
    }

    public String getEffectiveersion() {
        return this.effectiveCoordinates == null ? this.version : this.effectiveCoordinates.getVersion();
    }

    public boolean hasInclusions() {
        return this.inclusions == null ? false : !this.inclusions.isEmpty();
    }

    public Collection<ArtifactBasicMetadata> getInclusions() {
        return this.inclusions;
    }

    public void setInclusions(Collection<ArtifactBasicMetadata> inclusions) {
        this.inclusions = inclusions;
    }

    public boolean hasExclusions() {
        return this.exclusions == null ? false : !this.exclusions.isEmpty();
    }

    public Collection<ArtifactBasicMetadata> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(Collection<ArtifactBasicMetadata> exclusions) {
        this.exclusions = exclusions;
    }

    public boolean allowDependency(ArtifactBasicMetadata dep) throws VersionException {
        boolean includeDependency = true;
        if (this.hasInclusions()) {
            boolean bl = includeDependency = !this.passesFilter(this.inclusions, dep);
        }
        if (!includeDependency) {
            return false;
        }
        if (!this.hasExclusions()) {
            return true;
        }
        return this.passesFilter(this.exclusions, dep);
    }

    private boolean passesFilter(Collection<ArtifactBasicMetadata> filter, ArtifactBasicMetadata dep) throws VersionException {
        for (ArtifactBasicMetadata filterMd : filter) {
            if (!filterMd.sameGA(dep)) continue;
            if (!filterMd.hasVersion()) {
                return false;
            }
            VersionRange vr = VersionRangeFactory.create(filterMd.getVersion());
            if (!vr.includes(dep.getVersion())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ArtifactBasicMetadata)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

