/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.event;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.mercury.event.EventTypeEnum;
import org.apache.maven.mercury.event.MercuryEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMercuryEvent
implements MercuryEvent {
    EventTypeEnum _type;
    String _name;
    String _tag;
    String _info;
    String _result;
    long _start;
    long _duration;
    Map<String, Object> _payload;

    public AbstractMercuryEvent() {
        this.start();
    }

    public AbstractMercuryEvent(EventTypeEnum type, String name) {
        this();
        this._type = type;
        this._name = name;
    }

    public AbstractMercuryEvent(EventTypeEnum type, String name, String info) {
        this(type, name);
        this._info = info;
    }

    @Override
    public long getDuration() {
        return this._duration;
    }

    @Override
    public Map<String, Object> getPayload() {
        return null;
    }

    @Override
    public long getStart() {
        return this._start;
    }

    @Override
    public EventTypeEnum getType() {
        return this._type;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getInfo() {
        return this._info;
    }

    @Override
    public String getTag() {
        return this._tag;
    }

    @Override
    public String getResult() {
        return this._result;
    }

    @Override
    public void setResult(String result) {
        this._result = result;
    }

    @Override
    public void setTag(String tag) {
        this._tag = tag;
    }

    @Override
    public void setInfo(String info) {
        this._info = info;
    }

    @Override
    public boolean hasResult() {
        return this._result != null;
    }

    @Override
    public Object getPayload(String name) {
        return this._payload == null ? null : this._payload.get(name);
    }

    @Override
    public void setPayload(Map<String, Object> payload) {
        this._payload = payload;
    }

    @Override
    public void setPayload(String name, Object value) {
        if (this._payload == null) {
            this._payload = new HashMap<String, Object>(4);
        }
        this._payload.put(name, value);
    }

    @Override
    public void start() {
        this._start = System.currentTimeMillis();
    }

    @Override
    public void stop() {
        this._duration = System.currentTimeMillis() - this._start;
    }
}

