/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.metadata;

import java.util.List;
import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.repository.metadata.MetadataOperation;
import org.apache.maven.mercury.repository.metadata.StringOperand;
import org.apache.maven.mercury.repository.metadata.Versioning;
import org.apache.maven.mercury.util.TimeUtil;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public class AddVersionOperation
implements MetadataOperation {
    private static final Language lang = new DefaultLanguage(AddVersionOperation.class);
    private String version;

    public AddVersionOperation(StringOperand data) throws MetadataException {
        this.setOperand(data);
    }

    public void setOperand(Object data) throws MetadataException {
        if (data == null || !(data instanceof StringOperand)) {
            throw new MetadataException(lang.getMessage("bad.operand", new String[]{"StringOperand", data == null ? "null" : data.getClass().getName()}));
        }
        this.version = ((StringOperand)data).getOperand();
    }

    public boolean perform(Metadata metadata) throws MetadataException {
        List vl;
        if (metadata == null) {
            return false;
        }
        Versioning vs = metadata.getVersioning();
        if (vs == null) {
            vs = new Versioning();
            metadata.setVersioning(vs);
        }
        if (vs.getVersions() != null && vs.getVersions().size() > 0 && (vl = vs.getVersions()).contains(this.version)) {
            return false;
        }
        vs.addVersion(this.version);
        vs.setLastUpdated(TimeUtil.getUTCTimestamp());
        return true;
    }
}

