/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.mercury.artifact.Quality;
import org.apache.maven.mercury.artifact.QualityRange;
import org.apache.maven.mercury.builder.api.DependencyProcessor;
import org.apache.maven.mercury.repository.api.Repository;
import org.apache.maven.mercury.repository.api.RepositoryException;
import org.apache.maven.mercury.repository.api.RepositoryReader;
import org.apache.maven.mercury.repository.api.RepositoryReaderFactory;
import org.apache.maven.mercury.repository.api.RepositoryWriter;
import org.apache.maven.mercury.repository.api.RepositoryWriterFactory;
import org.apache.maven.mercury.transport.api.Server;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public abstract class AbstractRepository
implements Repository {
    private static final Language lang = new DefaultLanguage(AbstractRepository.class);
    public static final String DEFAULT_REMOTE_READ_PROTOCOL = "http";
    public static final String DEFAULT_REMOTE_WRITE_PROTOCOL = "http";
    public static final String DEFAULT_LOCAL_READ_PROTOCOL = "file";
    public static final String DEFAULT_LOCAL_WRITE_PROTOCOL = "file";
    public static final String DEFAULT_REPOSITORY_TYPE = "m2";
    private String id;
    private String defaultReadProtocol = "http";
    private String defaultWriteProtocol = "http";
    private static Map<String, RepositoryReaderFactory> readerRegistry = Collections.synchronizedMap(new HashMap(4));
    private static Map<String, RepositoryWriterFactory> writerRegistry = Collections.synchronizedMap(new HashMap(4));
    protected String type = "m2";
    protected QualityRange repositoryQualityRange = QualityRange.ALL;
    protected QualityRange versionRangeQualityRange = QualityRange.ALL;
    protected DependencyProcessor dependencyProcessor;
    protected Server server;

    public AbstractRepository(String id, String type) {
        this.id = id;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public QualityRange getRepositoryQualityRange() {
        return this.repositoryQualityRange;
    }

    public void setRepositoryQualityRange(QualityRange repositoryQualityRange) {
        this.repositoryQualityRange = repositoryQualityRange;
    }

    public QualityRange getVersionRangeQualityRange() {
        return this.versionRangeQualityRange;
    }

    public void setVersionRangeQualityRange(QualityRange versionRangeQualityRange) {
        this.versionRangeQualityRange = versionRangeQualityRange;
    }

    public String getDefaultReadProtocol() {
        return this.defaultReadProtocol;
    }

    public void setDefaultReadProtocol(String defaultReadProtocol) {
        this.defaultReadProtocol = defaultReadProtocol;
    }

    public String getDefaultWriteProtocol() {
        return this.defaultWriteProtocol;
    }

    public void setDefaultWriteProtocol(String defaultWriteProtocol) {
        this.defaultWriteProtocol = defaultWriteProtocol;
    }

    public static void register(String type, RepositoryReaderFactory readerFactory) throws IllegalArgumentException {
        if (type == null || type.length() < 1) {
            throw new IllegalArgumentException(lang.getMessage("null.reader.type", new String[0]));
        }
        if (readerFactory == null) {
            throw new IllegalArgumentException(lang.getMessage("null.reader.factory", new String[0]));
        }
        readerRegistry.put(type, readerFactory);
    }

    public static void register(String type, RepositoryWriterFactory writerFactory) throws IllegalArgumentException {
        if (type == null || type.length() < 1) {
            throw new IllegalArgumentException(lang.getMessage("null.writer.type", new String[0]));
        }
        if (writerFactory == null) {
            throw new IllegalArgumentException(lang.getMessage("null.writer.factory", new String[0]));
        }
        writerRegistry.put(type, writerFactory);
    }

    public static void unregisterReader(String type) throws IllegalArgumentException {
        if (type == null || type.length() < 1) {
            throw new IllegalArgumentException(lang.getMessage("null.reader.type", new String[0]));
        }
        readerRegistry.remove(type);
    }

    public static void unregisterWriter(String type) throws IllegalArgumentException {
        if (type == null || type.length() < 1) {
            throw new IllegalArgumentException(lang.getMessage("null.writer.type", new String[0]));
        }
        writerRegistry.remove(type);
    }

    public static RepositoryReader getReader(String type, Repository repo, DependencyProcessor mdProcessor) throws IllegalArgumentException, RepositoryException {
        if (type == null || type.length() < 1) {
            throw new IllegalArgumentException(lang.getMessage("null.reader.type", new String[0]));
        }
        if (repo == null) {
            throw new IllegalArgumentException(lang.getMessage("null.reader.repo", new String[0]));
        }
        RepositoryReaderFactory rf = readerRegistry.get(type);
        if (rf == null) {
            throw new RepositoryException(lang.getMessage("null.reader.factory.found", new String[0]));
        }
        return rf.getReader(repo, mdProcessor);
    }

    public static RepositoryWriter getWriter(String type, Repository repo) throws IllegalArgumentException, RepositoryException {
        if (type == null || type.length() < 1) {
            throw new IllegalArgumentException(lang.getMessage("null.writer.type", new String[0]));
        }
        if (repo == null) {
            throw new IllegalArgumentException(lang.getMessage("null.writer.repo", new String[0]));
        }
        RepositoryWriterFactory wf = writerRegistry.get(type);
        if (wf == null) {
            throw new RepositoryException(lang.getMessage("null.writer.factory.found", new String[0]));
        }
        return wf.getWriter(repo);
    }

    public boolean isSnapshots() {
        return this.repositoryQualityRange.isAcceptedQuality(Quality.SNAPSHOT_QUALITY);
    }

    public boolean isReleases() {
        return this.repositoryQualityRange.isAcceptedQuality(Quality.RELEASE_QUALITY);
    }

    public boolean isAcceptedQuality(Quality quality) {
        return this.repositoryQualityRange.isAcceptedQuality(quality);
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean hasDependencyProcessor() {
        return this.dependencyProcessor == null;
    }

    public DependencyProcessor getDependencyProcessor() {
        return this.dependencyProcessor;
    }

    public void setDependencyProcessor(DependencyProcessor dependencyProcessor) {
        this.dependencyProcessor = dependencyProcessor;
    }
}

