/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.api;

import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.mercury.artifact.ArtifactCoordinates;
import org.apache.maven.mercury.artifact.version.VersionComparator;
import org.apache.maven.mercury.repository.api.RepositoryGAVMetadata;
import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.util.TimeUtil;
import org.apache.maven.mercury.util.Util;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryGAMetadata {
    private static final Language _lang = new DefaultLanguage(RepositoryGAVMetadata.class);
    protected ArtifactCoordinates ga;
    protected TreeSet<String> versions = new TreeSet(new VersionComparator());
    protected long lastCheck;
    protected transient boolean expired = false;

    protected RepositoryGAMetadata() {
    }

    public RepositoryGAMetadata(ArtifactCoordinates ga, Collection<String> versions) {
        this.ga = ga;
        if (!Util.isEmpty(versions)) {
            this.versions.addAll(versions);
        }
        this.lastCheck = TimeUtil.getUTCTimestampAsLong();
    }

    public RepositoryGAMetadata(Metadata md) throws MetadataException {
        if (md == null) {
            throw new IllegalArgumentException(_lang.getMessage("empty.md", new String[0]));
        }
        this.ga = new ArtifactCoordinates(md.getGroupId(), md.getArtifactId(), md.getVersion());
        List vers = null;
        if (md.getVersioning() != null) {
            vers = md.getVersioning().getVersions();
            this.versions.addAll(vers);
        }
        this.lastCheck = TimeUtil.getUTCTimestampAsLong();
    }

    public RepositoryGAMetadata(RepositoryGAMetadata md) throws MetadataException {
        this.ga = md.getGA();
        if (!Util.isEmpty(md.getVersions())) {
            this.versions.addAll(md.getVersions());
        }
        this.lastCheck = TimeUtil.getUTCTimestampAsLong();
    }

    public TreeSet<String> getVersions() {
        return this.versions;
    }

    public long getLastCheckTs() {
        return this.lastCheck;
    }

    public long getLastCheckMillis() throws ParseException {
        return TimeUtil.toMillis((long)this.lastCheck);
    }

    public void update(Collection<String> versions) {
        this.versions.addAll(versions);
        this.lastCheck = TimeUtil.getUTCTimestampAsLong();
    }

    public ArtifactCoordinates getGA() {
        return this.ga;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }
}

