/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.virtual;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.mercury.artifact.ArtifactMetadata;
import org.apache.maven.mercury.artifact.Quality;
import org.apache.maven.mercury.artifact.api.ArtifactListProcessor;
import org.apache.maven.mercury.artifact.api.ArtifactListProcessorException;
import org.apache.maven.mercury.artifact.version.MetadataVersionComparator;
import org.apache.maven.mercury.artifact.version.VersionException;
import org.apache.maven.mercury.artifact.version.VersionRange;
import org.apache.maven.mercury.artifact.version.VersionRangeFactory;
import org.apache.maven.mercury.builder.api.MetadataReader;
import org.apache.maven.mercury.builder.api.MetadataReaderException;
import org.apache.maven.mercury.event.EventGenerator;
import org.apache.maven.mercury.event.EventManager;
import org.apache.maven.mercury.event.EventTypeEnum;
import org.apache.maven.mercury.event.GenericEvent;
import org.apache.maven.mercury.event.MercuryEvent;
import org.apache.maven.mercury.event.MercuryEventListener;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.repository.api.ArtifactBasicResults;
import org.apache.maven.mercury.repository.api.ArtifactResults;
import org.apache.maven.mercury.repository.api.LocalRepository;
import org.apache.maven.mercury.repository.api.RemoteRepository;
import org.apache.maven.mercury.repository.api.Repository;
import org.apache.maven.mercury.repository.api.RepositoryException;
import org.apache.maven.mercury.repository.api.RepositoryMetadataCache;
import org.apache.maven.mercury.repository.api.RepositoryReader;
import org.apache.maven.mercury.repository.api.RepositoryWriter;
import org.apache.maven.mercury.repository.cache.fs.MetadataCacheFs;
import org.apache.maven.mercury.util.Util;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualRepositoryReader
implements MetadataReader,
EventGenerator {
    public static final String EVENT_READ_ARTIFACTS = "read.artifacts";
    public static final String EVENT_READ_ARTIFACTS_FROM_REPO = "read.artifacts.from.repo";
    public static final String EVENT_READ_ARTIFACTS_FROM_REPO_QUALIFIED = "read.artifacts.from.repo.qualified";
    public static final String EVENT_READ_ARTIFACTS_FROM_REPO_UNQUALIFIED = "read.artifacts.from.repo.unqualified";
    public static final String EVENT_READ_VERSIONS = "read.versions";
    public static final String EVENT_READ_VERSIONS_FROM_REPO = "read.versions.from.repo";
    public static final String EVENT_READ_DEPENDENCIES = "read.dependencies";
    public static final String EVENT_READ_DEPENDENCIES_FROM_REPO = "read.dependencies.from.repo";
    public static final String EVENT_READ_RAW = "vr.read.raw";
    public static final String EVENT_READ_RAW_FROM_REPO = "read.raw.from.repo";
    public static final String METADATA_CACHE_DIR = ".cache";
    private static int MIN_PARALLEL = 5;
    private static final Language _lang = new DefaultLanguage(VirtualRepositoryReader.class);
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(VirtualRepositoryReader.class);
    private List<Repository> _repositories = new ArrayList<Repository>(8);
    private RepositoryReader[] _repositoryReaders;
    private LocalRepository _localRepository;
    private RepositoryWriter _localRepositoryWriter;
    RepositoryMetadataCache _mdCache;
    private Map<String, ArtifactListProcessor> _processors;
    private boolean _initialized = false;
    private EventManager _eventManager;

    public VirtualRepositoryReader(Collection<Repository> repositories) throws RepositoryException {
        if (!Util.isEmpty(repositories)) {
            this._repositories.addAll(repositories);
        }
    }

    private VirtualRepositoryReader(LocalRepository localRepository, Collection<RemoteRepository> remoteRepositories) throws RepositoryException {
        if (this._localRepository == null) {
            throw new RepositoryException("null local repo");
        }
        this._localRepository = localRepository;
        this._repositories.add((Repository)localRepository);
        if (remoteRepositories != null && remoteRepositories.size() > 0) {
            this._repositories.addAll(remoteRepositories);
        }
    }

    private VirtualRepositoryReader(Repository ... repositories) throws RepositoryException {
        if (repositories != null && repositories.length > 0) {
            for (Repository r : repositories) {
                this._repositories.add(r);
            }
        }
    }

    public static final RepositoryMetadataCache getCache(File localRepositoryRoot) throws IOException {
        return MetadataCacheFs.getCache((File)new File(localRepositoryRoot, METADATA_CACHE_DIR));
    }

    public void addRepository(Repository repo) throws RepositoryException {
        if (this._initialized) {
            throw new RepositoryException("cannot add repositories after VirtualReader has been initialized");
        }
        this._repositories.add(repo);
    }

    public void setProcessors(Map<String, ArtifactListProcessor> processors) {
        this._processors = processors;
    }

    public void init() throws RepositoryException {
        RepositoryReader rr;
        if (this._initialized) {
            return;
        }
        this._repositoryReaders = new RepositoryReader[this._repositories.size()];
        int i = 0;
        for (Repository r : this._repositories) {
            if (!r.isLocal() || !r.isReadable()) continue;
            rr = r.getReader();
            rr.setMetadataReader((MetadataReader)this);
            this._repositoryReaders[i++] = rr;
            if (!r.isWriteable() || this._localRepository != null) continue;
            this._localRepository = (LocalRepository)r.getReader().getRepository();
            this._localRepositoryWriter = this._localRepository.getWriter();
            if (this._mdCache != null) continue;
            try {
                this._mdCache = VirtualRepositoryReader.getCache(this._localRepository.getDirectory());
                if (this._eventManager == null) continue;
                this._mdCache.setEventManager(this._eventManager);
            }
            catch (IOException e) {
                throw new RepositoryException(e.getMessage());
            }
        }
        for (Repository r : this._repositories) {
            if (r.isLocal() || !r.isReadable()) continue;
            rr = r.getReader();
            if (this._mdCache != null) {
                rr.setMetadataCache(this._mdCache);
            }
            rr.setMetadataReader((MetadataReader)this);
            this._repositoryReaders[i++] = rr;
        }
        this._initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactBasicResults readVersions(Collection<ArtifactBasicMetadata> query) throws IllegalArgumentException, RepositoryException {
        if (query == null) {
            throw new IllegalArgumentException("null bmd supplied");
        }
        this.init();
        GenericEvent event = null;
        try {
            if (this._eventManager != null) {
                event = new GenericEvent(EventTypeEnum.virtualRepositoryReader, EVENT_READ_VERSIONS);
            }
            ArtifactBasicResults res = null;
            ArtifactListProcessor tp = this._processors == null ? null : this._processors.get(ArtifactListProcessor.FUNCTION_TP);
            GenericEvent eventRead = null;
            ArrayList<ArtifactBasicMetadata> qList = new ArrayList<ArtifactBasicMetadata>(query.size());
            qList.addAll(query);
            for (RepositoryReader rr : this._repositoryReaders) {
                block24: {
                    if (!qList.isEmpty()) break block24;
                    if (this._eventManager == null) break;
                    eventRead.stop();
                    this._eventManager.fireEvent(eventRead);
                    break;
                }
                try {
                    ArtifactBasicResults repoRes;
                    if (this._eventManager != null) {
                        eventRead = new GenericEvent(EventTypeEnum.virtualRepositoryReader, EVENT_READ_VERSIONS_FROM_REPO, rr.getRepository().getId());
                    }
                    if ((repoRes = rr.readVersions(qList)) != null && repoRes.hasResults()) {
                        for (ArtifactBasicMetadata key : repoRes.getResults().keySet()) {
                            Quality keyQuality;
                            List rorRes = repoRes.getResult(key);
                            if (tp != null) {
                                try {
                                    tp.configure((Object)key);
                                    rorRes = tp.process(rorRes);
                                }
                                catch (ArtifactListProcessorException e) {
                                    throw new RepositoryException((Throwable)e);
                                }
                            }
                            if (Util.isEmpty((Collection)rorRes)) {
                                eventRead.setResult("none found");
                                continue;
                            }
                            for (ArtifactBasicMetadata bmd : rorRes) {
                                bmd.setTracker((Object)rr);
                            }
                            if (res == null) {
                                res = new ArtifactBasicResults(key, rorRes);
                            } else {
                                res.add(key, rorRes);
                            }
                            String keyVersion = key.getVersion();
                            VersionRange keyVersionRange = null;
                            try {
                                keyVersionRange = VersionRangeFactory.create((String)key.getVersion());
                            }
                            catch (VersionException e) {
                                throw new RepositoryException(_lang.getMessage("query.element.bad.version", new String[]{key.toString(), e.getMessage()}));
                            }
                            if (!keyVersionRange.isSingleton() || (keyQuality = new Quality(keyVersion)).compareTo(Quality.RELEASE_QUALITY) != 0) continue;
                            qList.remove(key);
                        }
                    }
                    if (this._eventManager != null) {
                        eventRead.setResult("repo done");
                    }
                    if (this._eventManager == null) continue;
                }
                catch (Throwable throwable) {
                    if (this._eventManager != null) {
                        eventRead.stop();
                        this._eventManager.fireEvent(eventRead);
                    }
                    throw throwable;
                }
                eventRead.stop();
                this._eventManager.fireEvent((MercuryEvent)eventRead);
            }
            ArtifactBasicResults artifactBasicResults = res;
            return artifactBasicResults;
        }
        finally {
            if (this._eventManager != null) {
                event.stop();
                this._eventManager.fireEvent((MercuryEvent)event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactMetadata readDependencies(ArtifactBasicMetadata bmd) throws IllegalArgumentException, RepositoryException {
        if (bmd == null) {
            throw new IllegalArgumentException("null bmd supplied");
        }
        GenericEvent event = null;
        try {
            if (this._eventManager != null) {
                event = new GenericEvent(EventTypeEnum.virtualRepositoryReader, EVENT_READ_DEPENDENCIES, bmd.toString());
            }
            this.init();
            ArrayList<ArtifactBasicMetadata> query = new ArrayList<ArtifactBasicMetadata>(1);
            query.add(bmd);
            ArtifactMetadata md = new ArtifactMetadata(bmd);
            RepositoryReader[] repos = this._repositoryReaders;
            Object tracker = bmd.getTracker();
            if (tracker != null && RepositoryReader.class.isAssignableFrom(tracker.getClass())) {
                repos = new RepositoryReader[]{(RepositoryReader)tracker};
            }
            GenericEvent eventRead = null;
            for (RepositoryReader rr : repos) {
                block15: {
                    ArtifactMetadata artifactMetadata;
                    block16: {
                        try {
                            ArtifactBasicResults res;
                            if (this._eventManager != null) {
                                eventRead = new GenericEvent(EventTypeEnum.virtualRepositoryReader, EVENT_READ_DEPENDENCIES_FROM_REPO, rr.getRepository().getId());
                            }
                            if ((res = rr.readDependencies(query)) == null || !res.hasResults(bmd)) break block15;
                            md.setDependencies(res.getResult(bmd));
                            md.setTracker((Object)rr);
                            if (this._eventManager != null) {
                                eventRead.setInfo(eventRead.getInfo() + ", found: " + md.getDependencies());
                            }
                            artifactMetadata = md;
                            if (this._eventManager == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (this._eventManager != null) {
                                eventRead.stop();
                                this._eventManager.fireEvent(eventRead);
                            }
                            throw throwable;
                        }
                        eventRead.stop();
                        this._eventManager.fireEvent((MercuryEvent)eventRead);
                    }
                    return artifactMetadata;
                }
                if (this._eventManager == null) continue;
                eventRead.stop();
                this._eventManager.fireEvent((MercuryEvent)eventRead);
            }
            if (this._eventManager != null) {
                event.setResult("not found");
            }
            ArtifactMetadata artifactMetadata = md;
            return artifactMetadata;
        }
        finally {
            if (this._eventManager != null) {
                event.stop();
                this._eventManager.fireEvent((MercuryEvent)event);
            }
        }
    }

    private Map<RepositoryReader, List<ArtifactBasicMetadata>> sortByRepo(Collection<? extends ArtifactBasicMetadata> query) {
        HashMap res = null;
        ArrayList<ArtifactBasicMetadata> rejects = null;
        for (ArtifactBasicMetadata artifactBasicMetadata : query) {
            Object tracker = artifactBasicMetadata.getTracker();
            if (tracker != null && RepositoryReader.class.isAssignableFrom(tracker.getClass())) {
                ArrayList<ArtifactBasicMetadata> rl;
                RepositoryReader rr = (RepositoryReader)tracker;
                if (res == null) {
                    res = new HashMap();
                }
                if ((rl = (ArrayList<ArtifactBasicMetadata>)res.get(rr)) == null) {
                    rl = new ArrayList<ArtifactBasicMetadata>();
                    res.put(rr, rl);
                }
                rl.add(artifactBasicMetadata);
                continue;
            }
            if (rejects == null) {
                rejects = new ArrayList<ArtifactBasicMetadata>();
            }
            rejects.add(artifactBasicMetadata);
        }
        if (rejects != null) {
            if (res == null) {
                res = new HashMap();
            }
            res.put(RepositoryReader.NULL_READER, rejects);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactResults readArtifacts(Collection<? extends ArtifactBasicMetadata> query) throws RepositoryException {
        ArtifactResults artifactResults;
        block25: {
            ArtifactResults res;
            GenericEvent event;
            block23: {
                ArtifactResults artifactResults2;
                block24: {
                    event = null;
                    res = null;
                    if (this._eventManager != null) {
                        event = new GenericEvent(EventTypeEnum.virtualRepositoryReader, EVENT_READ_ARTIFACTS, "");
                    }
                    if (!Util.isEmpty(query)) break block23;
                    artifactResults2 = res;
                    if (this._eventManager == null) break block24;
                    event.stop();
                    this._eventManager.fireEvent((MercuryEvent)event);
                }
                return artifactResults2;
            }
            try {
                List<ArtifactBasicMetadata> rejects;
                Map<RepositoryReader, List<ArtifactBasicMetadata>> buckets = this.sortByRepo(query);
                List<ArtifactBasicMetadata> list = rejects = buckets == null ? null : buckets.get(RepositoryReader.NULL_READER);
                if (buckets == null) {
                    throw new RepositoryException(_lang.getMessage("internal.error.sorting.query", new String[]{query.toString()}));
                }
                this.init();
                for (RepositoryReader rr : buckets.keySet()) {
                    if (RepositoryReader.NULL_READER.equals(rr)) continue;
                    String repoId = rr.getRepository().getId();
                    GenericEvent eventRead = null;
                    try {
                        List<ArtifactBasicMetadata> rrQuery;
                        ArtifactResults rrRes;
                        if (this._eventManager != null) {
                            eventRead = new GenericEvent(EventTypeEnum.virtualRepositoryReader, EVENT_READ_ARTIFACTS_FROM_REPO_QUALIFIED, repoId);
                        }
                        if ((rrRes = rr.readArtifacts(rrQuery = buckets.get(rr))).hasExceptions()) {
                            throw new RepositoryException(_lang.getMessage("error.reading.existing.artifact", new String[]{rrRes.getExceptions().toString(), rr.getRepository().getId()}));
                        }
                        if (!rrRes.hasResults()) continue;
                        for (ArtifactBasicMetadata bm : rrRes.getResults().keySet()) {
                            List al = rrRes.getResults(bm);
                            if (res == null) {
                                res = new ArtifactResults();
                            }
                            res.addAll(bm, al);
                            if (this._localRepository != null && repoId.equals(this._localRepository.getId()) || this._localRepositoryWriter == null) continue;
                            this._localRepositoryWriter.writeArtifacts((Collection)al);
                        }
                    }
                    finally {
                        if (this._eventManager == null) continue;
                        eventRead.stop();
                        this._eventManager.fireEvent((MercuryEvent)eventRead);
                    }
                }
                if (!Util.isEmpty(rejects)) {
                    for (RepositoryReader rr : this._repositoryReaders) {
                        if (rejects.isEmpty()) break;
                        String repoId = rr.getRepository().getId();
                        GenericEvent eventRead = null;
                        try {
                            ArtifactResults rrRes;
                            if (this._eventManager != null) {
                                eventRead = new GenericEvent(EventTypeEnum.virtualRepositoryReader, EVENT_READ_ARTIFACTS_FROM_REPO_UNQUALIFIED, repoId);
                            }
                            if (!(rrRes = rr.readArtifacts(rejects)).hasResults()) continue;
                            for (ArtifactBasicMetadata bm : rrRes.getResults().keySet()) {
                                List al = rrRes.getResults(bm);
                                if (res == null) {
                                    res = new ArtifactResults();
                                }
                                res.addAll(bm, al);
                                rejects.remove(bm);
                                if (this._localRepository != null && repoId.equals(this._localRepository.getId()) || this._localRepositoryWriter == null) continue;
                                this._localRepositoryWriter.writeArtifacts((Collection)al);
                            }
                        }
                        finally {
                            if (this._eventManager != null) {
                                eventRead.stop();
                                this._eventManager.fireEvent((MercuryEvent)eventRead);
                            }
                        }
                    }
                }
                artifactResults = res;
                if (this._eventManager == null) break block25;
            }
            catch (Throwable throwable) {
                if (this._eventManager != null) {
                    event.stop();
                    this._eventManager.fireEvent(event);
                }
                throw throwable;
            }
            event.stop();
            this._eventManager.fireEvent((MercuryEvent)event);
        }
        return artifactResults;
    }

    public byte[] readMetadata(ArtifactBasicMetadata bmd) throws MetadataReaderException {
        if (_log.isDebugEnabled()) {
            _log.debug("Asking for pom: " + bmd);
        }
        return this.readRawData(bmd, "", "pom");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readRawData(ArtifactBasicMetadata bmd, String classifier, String type) throws MetadataReaderException {
        byte[] byArray;
        block30: {
            GenericEvent event = null;
            String eventTag = null;
            if (_log.isDebugEnabled()) {
                _log.debug("request for " + bmd + ", classifier=" + classifier + ", type=" + type);
            }
            if (bmd == null) {
                throw new IllegalArgumentException("null bmd supplied");
            }
            try {
                if (this._eventManager != null) {
                    eventTag = bmd.toString() + (Util.isEmpty((String)classifier) ? "" : ", classifier=" + classifier) + (Util.isEmpty((String)type) ? "" : ", type=" + type);
                    event = new GenericEvent(EventTypeEnum.virtualRepositoryReader, EVENT_READ_RAW, eventTag);
                }
                ArtifactBasicMetadata bmdQuery = bmd;
                try {
                    this.init();
                }
                catch (RepositoryException e) {
                    throw new MetadataReaderException((Throwable)e);
                }
                byte[] res = null;
                Quality vq = new Quality(bmd.getVersion());
                if (_log.isDebugEnabled()) {
                    _log.debug("quality calculated as " + vq.getQuality() == null ? "null" : vq.getQuality().name());
                }
                if (Quality.SNAPSHOT_QUALITY.equals((Object)vq)) {
                    ArrayList<ArtifactBasicMetadata> query = new ArrayList<ArtifactBasicMetadata>(1);
                    query.add(bmd);
                    try {
                        ArtifactBasicResults vRes = this.readVersions(query);
                        if (Util.isEmpty((Object)vRes)) {
                            if (_log.isDebugEnabled()) {
                                _log.debug("no snapshots found - throw exception");
                            }
                            throw new MetadataReaderException(_lang.getMessage("no.snapshots", new String[]{bmd.toString(), classifier, type}));
                        }
                        if (!vRes.hasResults(bmd)) {
                            if (_log.isDebugEnabled()) {
                                _log.debug("no snapshots found - throw exception");
                            }
                            throw new MetadataReaderException(_lang.getMessage("no.snapshots", new String[]{bmd.toString(), classifier, type}));
                        }
                        List versions = vRes.getResult(bmd);
                        TreeSet snapshots = new TreeSet(new MetadataVersionComparator());
                        snapshots.addAll(versions);
                        bmdQuery = (ArtifactBasicMetadata)snapshots.last();
                    }
                    catch (Exception e) {
                        throw new MetadataReaderException((Throwable)e);
                    }
                }
                for (RepositoryReader rr : this._repositoryReaders) {
                    GenericEvent eventRead;
                    block28: {
                        byte[] byArray2;
                        block29: {
                            eventRead = null;
                            if (this._eventManager != null) {
                                eventRead = new GenericEvent(EventTypeEnum.virtualRepositoryReader, EVENT_READ_RAW_FROM_REPO, rr.getRepository().getId() + ": " + eventTag);
                            }
                            if ((res = rr.readRawData(bmdQuery, classifier, type)) == null) break block28;
                            if (_log.isDebugEnabled()) {
                                _log.debug(bmdQuery + " found in " + rr.getRepository().getServer());
                            }
                            if (this._eventManager != null) {
                                eventRead.setInfo(eventRead.getInfo());
                            }
                            byArray2 = res;
                            if (this._eventManager == null) break block29;
                            {
                                catch (Throwable throwable) {
                                    if (this._eventManager != null) {
                                        eventRead.stop();
                                        this._eventManager.fireEvent(eventRead);
                                    }
                                    throw throwable;
                                }
                            }
                            eventRead.stop();
                            this._eventManager.fireEvent((MercuryEvent)eventRead);
                        }
                        if (this._eventManager != null) {
                            event.stop();
                            this._eventManager.fireEvent((MercuryEvent)event);
                        }
                        return byArray2;
                    }
                    if (this._eventManager != null) {
                        eventRead.setResult("not found");
                    }
                    if (this._eventManager == null) continue;
                    eventRead.stop();
                    this._eventManager.fireEvent((MercuryEvent)eventRead);
                }
            }
            catch (Throwable throwable) {
                if (this._eventManager != null) {
                    event.stop();
                    this._eventManager.fireEvent(event);
                }
                throw throwable;
            }
            {
                if (_log.isDebugEnabled()) {
                    _log.debug("no data found, returning null");
                }
                byArray = null;
                if (this._eventManager == null) break block30;
            }
            event.stop();
            this._eventManager.fireEvent((MercuryEvent)event);
        }
        return byArray;
    }

    public void register(MercuryEventListener listener) {
        if (this._eventManager == null) {
            this._eventManager = new EventManager();
        }
        this._eventManager.register(listener);
    }

    public void setEventManager(EventManager eventManager) {
        this._eventManager = eventManager;
    }

    public void unRegister(MercuryEventListener listener) {
        if (this._eventManager != null) {
            this._eventManager.unRegister(listener);
        }
    }
}

