/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.transport.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.mercury.transport.api.Binding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportTransaction {
    public static final int DEFAULT_SIZE = 32;
    protected Collection<Binding> _bindings;

    private void init() {
        this.init(32);
    }

    private void init(int n) {
        if (this._bindings == null) {
            this._bindings = new ArrayList<Binding>(n);
        }
    }

    public TransportTransaction() {
        this.init();
    }

    public TransportTransaction add(Binding binding) {
        this.init();
        this._bindings.add(binding);
        return this;
    }

    public TransportTransaction add(URL remoteResource, File localResource) {
        this.init();
        this._bindings.add(new Binding(remoteResource, localResource));
        return this;
    }

    public TransportTransaction add(URL remoteResource) {
        this.init();
        this._bindings.add(new Binding(remoteResource));
        return this;
    }

    public TransportTransaction add(URL remoteResource, InputStream is) {
        this.init();
        this._bindings.add(new Binding(remoteResource, is));
        return this;
    }

    public TransportTransaction add(URL remoteResource, byte[] localResource) {
        this.init();
        this._bindings.add(new Binding(remoteResource, new ByteArrayInputStream(localResource)));
        return this;
    }

    public Collection<Binding> getBindings() {
        return this._bindings == null ? Collections.EMPTY_LIST : this._bindings;
    }

    public void setBindings(List<Binding> bindings) {
        this._bindings = bindings;
    }

    public boolean isEmpty() {
        return this._bindings == null || this._bindings.size() < 1;
    }

    public boolean hasErrors() {
        if (this._bindings == null) {
            return false;
        }
        for (Binding b : this._bindings) {
            if (b.getError() == null) continue;
            return true;
        }
        return false;
    }

    public void clearErrors() {
        if (this._bindings == null) {
            return;
        }
        for (Binding b : this._bindings) {
            b.setError(null);
        }
    }
}

