/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.client;

import java.io.File;
import java.net.URL;
import org.apache.maven.mercury.spi.http.client.SecureSender;
import org.apache.maven.mercury.transport.api.Binding;
import org.apache.maven.mercury.transport.api.Server;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpExchange;

public abstract class FileExchange
extends HttpExchange {
    public static final String __BATCH_HEADER = "Jetty-Batch-Id";
    public static final String __BATCH_SUPPORTED_HEADER = "Jetty-Batch-Supported";
    public static final String __BATCH_COMMIT_HEADER = "Jetty-Batch-Commit";
    public static final String __BATCH_DISCARD_HEADER = "Jetty-Batch-Discard";
    protected HttpClient _httpClient;
    protected int _status;
    protected String _url;
    protected File _localFile;
    protected Binding _binding;
    protected Server _server;

    public abstract void onFileComplete(String var1, File var2);

    public abstract void onFileError(String var1, Exception var2);

    public FileExchange(Server server, Binding binding, File localFile, HttpClient client) {
        URL url;
        this._server = server;
        this._binding = binding;
        if (this._binding != null && (url = binding.getRemoteResource()) != null) {
            this._url = url.toString();
        }
        this._localFile = localFile;
        this._httpClient = client;
        this.setURL(this._url);
    }

    public void send() {
        try {
            SecureSender.send(this._server, this._httpClient, this);
        }
        catch (Exception e) {
            this.onFileError(this._url, e);
        }
    }

    protected void onResponseStatus(Buffer version, int status, Buffer reason) {
        this._status = status;
    }

    protected void onException(Throwable ex) {
        this.onFileError(this._url, new Exception(ex));
    }

    protected void onExpire() {
        this.onFileError(this._url, new Exception("Timeout occurred"));
    }

    protected void onConnectionFailed(Throwable ex) {
        this.onFileError(this._url, new Exception(ex));
    }
}

