/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.client;

import java.util.Map;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HandshakeExchange
extends HttpExchange {
    private HttpClient _httpClient;
    private String _method;
    private String _url;
    private Map<String, String> _headers;
    private int _status;

    public abstract void onHandshakeComplete(String var1);

    public abstract void onHandshakeError(String var1, Exception var2);

    public HandshakeExchange(HttpClient httpClient, String method, String url, Map<String, String> headers) {
        this._httpClient = httpClient;
        this._method = method;
        this._url = url;
        this._headers = headers;
    }

    public void send() {
        try {
            this.setMethod(this._method);
            this.setURL(this._url);
            if (this._headers != null) {
                for (Map.Entry<String, String> e : this._headers.entrySet()) {
                    this.setRequestHeader(e.getKey(), e.getValue());
                }
            }
            this._httpClient.send((HttpExchange)this);
        }
        catch (Exception e) {
            this.onHandshakeError(this._url, new Exception(null, e));
        }
    }

    protected void onResponseStatus(Buffer version, int status, Buffer reason) {
        this._status = status;
    }

    protected void onException(Throwable ex) {
        this.onHandshakeError(this._url, new Exception(ex));
    }

    protected void onExpire() {
        this.onHandshakeError(this._url, new Exception("Timeout occurred"));
    }

    protected void onResponseComplete() {
        if (this._status != 200) {
            this.onHandshakeError(this._url, new Exception("Http Error Code:" + this._status));
        } else {
            this.onHandshakeComplete(this._url);
        }
    }
}

