/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.client;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.mercury.crypto.api.StreamObserver;
import org.apache.maven.mercury.crypto.api.StreamObserverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableInputStream
extends FilterInputStream {
    Set<StreamObserver> observers = new HashSet<StreamObserver>();

    public ObservableInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.notifyListeners(b, off, result);
        }
        return result;
    }

    @Override
    public int read() throws IOException {
        int ch = this.in.read();
        if (ch != -1) {
            this.notifyListeners(ch);
        }
        return ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(StreamObserver o) {
        Set<StreamObserver> set = this.observers;
        synchronized (set) {
            this.observers.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObservers(Collection<? extends StreamObserver> observers) {
        Set<StreamObserver> set = this.observers;
        synchronized (set) {
            this.observers.addAll(observers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(byte[] b, int off, int len) throws IOException {
        Set<StreamObserver> set = this.observers;
        synchronized (set) {
            for (StreamObserver o : this.observers) {
                try {
                    o.bytesReady(b, off, len);
                }
                catch (StreamObserverException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int b) throws IOException {
        Set<StreamObserver> set = this.observers;
        synchronized (set) {
            for (StreamObserver o : this.observers) {
                try {
                    o.byteReady(b);
                }
                catch (StreamObserverException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
    }
}

