/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.client;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.mercury.crypto.api.StreamObserver;
import org.apache.maven.mercury.crypto.api.StreamObserverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableOutputStream
extends FilterOutputStream {
    Set<StreamObserver> observers = new HashSet<StreamObserver>();

    public ObservableOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.notifyListeners(b);
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.notifyListeners(b, off, len);
        this.out.write(b, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(StreamObserver o) {
        Set<StreamObserver> set = this.observers;
        synchronized (set) {
            this.observers.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObservers(Collection<? extends StreamObserver> observers) {
        Set<StreamObserver> set = this.observers;
        synchronized (set) {
            this.observers.addAll(observers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(byte[] b, int off, int len) throws IOException {
        Set<StreamObserver> set = this.observers;
        synchronized (set) {
            for (StreamObserver o : this.observers) {
                try {
                    o.bytesReady(b, off, len);
                }
                catch (StreamObserverException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int b) throws IOException {
        Set<StreamObserver> set = this.observers;
        synchronized (set) {
            for (StreamObserver o : this.observers) {
                try {
                    o.byteReady(b);
                }
                catch (StreamObserverException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
    }
}

