/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.client.deploy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.mercury.crypto.api.StreamObserver;
import org.apache.maven.mercury.crypto.api.StreamVerifier;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.spi.http.client.HttpClientException;
import org.apache.maven.mercury.spi.http.client.deploy.FilePutExchange;
import org.apache.maven.mercury.spi.http.validate.Validator;
import org.apache.maven.mercury.transport.api.Binding;
import org.apache.maven.mercury.transport.api.Server;
import org.mortbay.jetty.client.HttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeploymentTarget {
    private static final IMercuryLogger log = MercuryLoggerManager.getLogger(DeploymentTarget.class);
    protected Server _server;
    protected HttpClient _httpClient;
    protected String _batchId;
    protected Binding _binding;
    protected Set<Validator> _validators;
    protected TargetState _targetState;
    protected TargetState _checksumState;
    protected HttpClientException _exception;
    protected String _remoteJettyUrl;
    protected Set<StreamObserver> _observers = new HashSet<StreamObserver>();
    protected List<StreamVerifier> _verifiers = new ArrayList<StreamVerifier>();
    protected int _checkSumFilesDeployed = -1;

    public abstract void onComplete();

    public abstract void onError(HttpClientException var1);

    public DeploymentTarget(Server server, HttpClient client, String batchId, Binding binding, Set<Validator> validators, Set<StreamObserver> observers) {
        this._server = server;
        this._httpClient = client;
        this._batchId = batchId;
        this._binding = binding;
        this._validators = validators;
        for (StreamObserver o : observers) {
            if (StreamVerifier.class.isAssignableFrom(o.getClass())) {
                this._verifiers.add((StreamVerifier)o);
            }
            this._observers.add(o);
        }
        if (this._binding == null) {
            throw new IllegalArgumentException("Nothing to deploy - null binding");
        }
        if (this._binding.isFile() && (this._binding.getLocalFile() == null || !this._binding.getLocalFile().exists())) {
            throw new IllegalArgumentException("Nothing to deploy - local file not found: " + this._binding.getLocalFile());
        }
        if (this._binding.isInMemory() && this._binding.getLocalInputStream() == null) {
            throw new IllegalArgumentException("Nothing to deploy - inMemory binding with null stream");
        }
        this._targetState = new TargetState();
        this._checksumState = new TargetState();
        if (this._verifiers.isEmpty()) {
            this._checksumState.ready();
        }
    }

    public Binding getBinding() {
        return this._binding;
    }

    public void deploy() {
        this.updateState(null);
    }

    private synchronized void updateState(Throwable t) {
        if (log.isDebugEnabled()) {
            log.debug("updateState: exception=" + t + " targetState=" + this._targetState.getState() + " checksumState=" + this._checksumState.getState() + " verifiers=" + this._verifiers.size() + " checksumsdeployed=" + this._checkSumFilesDeployed);
        }
        if (t != null && this._exception == null) {
            HttpClientException httpClientException = this._exception = t instanceof HttpClientException ? (HttpClientException)t : new HttpClientException(this._binding, t);
        }
        if (this._exception != null) {
            this.onError(this._exception);
        } else if (this._targetState.isStart()) {
            this.deployLocalFile();
        } else if (this._targetState.isReady() && this._verifiers.size() > 0 && this._checkSumFilesDeployed < this._verifiers.size() - 1) {
            this.deployNextChecksumFile();
        } else if (this._targetState.isReady() && this._checksumState.isReady()) {
            this.onComplete();
        }
    }

    private void deployLocalFile() {
        FilePutExchange fileExchange = new FilePutExchange(this._server, this._batchId, this._binding, this._binding.getLocalFile(), this._observers, this._httpClient){

            public void onFileComplete(String url, File localFile) {
                DeploymentTarget.this._remoteJettyUrl = this.getRemoteJettyUrl();
                DeploymentTarget.this._targetState.ready();
                DeploymentTarget.this.updateState(null);
            }

            public void onFileError(String url, Exception e) {
                DeploymentTarget.this._remoteJettyUrl = this.getRemoteJettyUrl();
                DeploymentTarget.this._targetState.ready(e);
                DeploymentTarget.this.updateState(e);
            }
        };
        if (this._server != null && this._server.hasUserAgent()) {
            fileExchange.setRequestHeader("User-Agent", this._server.getUserAgent());
        }
        this._targetState.requested();
        fileExchange.send();
    }

    private void deployNextChecksumFile() {
        Binding binding = this._binding;
        File file = null;
        StreamVerifier v = this._verifiers.get(++this._checkSumFilesDeployed);
        try {
            URL url = this._binding.getRemoteResource();
            if (url != null) {
                url = new URL(url.toString() + v.getAttributes().getExtension());
            }
            String localFileName = this.getFileName(url);
            file = File.createTempFile(localFileName, ".tmp");
            file.deleteOnExit();
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            fw.write(v.getSignature());
            fw.close();
            binding = new Binding(url, file);
        }
        catch (Exception e) {
            this._checksumState.ready(e);
        }
        Set emptySet = Collections.emptySet();
        FilePutExchange checksumExchange = new FilePutExchange(this._server, this._batchId, binding, file, emptySet, this._httpClient){

            public void onFileComplete(String url, File localFile) {
                DeploymentTarget.this._remoteJettyUrl = this.getRemoteJettyUrl();
                if (DeploymentTarget.this._checkSumFilesDeployed == DeploymentTarget.this._verifiers.size() - 1) {
                    DeploymentTarget.this._checksumState.ready();
                }
                DeploymentTarget.this.updateState(null);
            }

            public void onFileError(String url, Exception e) {
                DeploymentTarget.this._remoteJettyUrl = this.getRemoteJettyUrl();
                if (DeploymentTarget.this._checkSumFilesDeployed == DeploymentTarget.this._verifiers.size() - 1) {
                    DeploymentTarget.this._checksumState.ready(e);
                }
                DeploymentTarget.this.updateState(e);
            }
        };
        if (this._server != null && this._server.hasUserAgent()) {
            checksumExchange.setRequestHeader("User-Agent", this._server.getUserAgent());
        }
        this._checksumState.requested();
        checksumExchange.send();
    }

    public boolean isRemoteJetty() {
        return this._remoteJettyUrl != null;
    }

    public String getRemoteJettyUrl() {
        return this._remoteJettyUrl;
    }

    public synchronized boolean isComplete() {
        return this._checksumState.isReady() && this._targetState.isReady();
    }

    public String getFileName(URL url) {
        if (url == null) {
            return "";
        }
        String localFileName = url.getFile();
        int i = localFileName.indexOf(63);
        if (i > 0) {
            localFileName = localFileName.substring(0, i);
        }
        if (localFileName.endsWith("/")) {
            localFileName = localFileName.substring(0, localFileName.length() - 1);
        }
        if ((i = localFileName.lastIndexOf(47)) >= 0) {
            localFileName = localFileName.substring(i + 1);
        }
        return localFileName;
    }

    public String toString() {
        return "DeploymentTarget:" + this._binding.getRemoteResource() + ":" + this._targetState + ":" + this._checksumState + ":" + this.isComplete();
    }

    public class TargetState {
        public static final int __START_STATE = 1;
        public static final int __REQUESTED_STATE = 2;
        public static final int __READY_STATE = 3;
        private int _state = 1;
        private Exception _exception;

        public synchronized void ready() {
            this.setState(3);
        }

        public synchronized void ready(Exception e) {
            this.setState(3);
            this._exception = e;
        }

        public synchronized void requested() {
            this.setState(2);
        }

        public synchronized boolean isStart() {
            return this._state == 1;
        }

        public synchronized boolean isRequested() {
            return this._state == 2;
        }

        public synchronized boolean isError() {
            return this._exception != null;
        }

        public boolean isReady() {
            return this._state == 3;
        }

        public synchronized void setState(int status) {
            this._state = status;
        }

        public synchronized int getState() {
            return this._state;
        }

        public synchronized Exception getException() {
            return this._exception;
        }
    }
}

