/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.client.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.mercury.crypto.api.StreamObserver;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.spi.http.client.FileExchange;
import org.apache.maven.mercury.spi.http.client.HttpClientException;
import org.apache.maven.mercury.spi.http.client.ObservableInputStream;
import org.apache.maven.mercury.transport.api.Binding;
import org.apache.maven.mercury.transport.api.Server;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.client.HttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilePutExchange
extends FileExchange {
    private static final int __readLimit = 1024;
    private static final IMercuryLogger log = MercuryLoggerManager.getLogger(FilePutExchange.class);
    private String _batchId;
    private InputStream _inputStream;
    private String _remoteRepoUrl;
    private String _remoteBatchId;
    private Set<StreamObserver> _observers = new HashSet<StreamObserver>();

    @Override
    public abstract void onFileComplete(String var1, File var2);

    @Override
    public abstract void onFileError(String var1, Exception var2);

    public FilePutExchange(Server server, String batchId, Binding binding, File localFile, Set<StreamObserver> observers, HttpClient client) {
        super(server, binding, localFile, client);
        this._observers.addAll(observers);
        this._batchId = batchId;
    }

    @Override
    public void send() {
        try {
            this.setMethod("PUT");
            this.setRequestHeader("Content-Type", "application/octet-stream");
            if (this._binding.isFile()) {
                this.setRequestHeader("Content-Length", String.valueOf(this._localFile.length()));
                if (log.isDebugEnabled()) {
                    log.debug("PUT of " + this._localFile.length() + " bytes");
                }
                for (StreamObserver o : this._observers) {
                    o.setLength(this._localFile.length());
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("PUT: " + this.getURI());
            }
            this.setRequestContentSource(this.getInputStream());
            this.setRequestHeader("Jetty-Batch-Id", this._batchId);
            super.send();
        }
        catch (Exception e) {
            this.onFileError(this._url, e);
        }
    }

    public boolean isRemoteJetty() {
        return this._remoteRepoUrl != null;
    }

    public String getRemoteJettyUrl() {
        return this._remoteRepoUrl;
    }

    protected void onResponseHeader(Buffer name, Buffer value) {
        if (name.toString().equalsIgnoreCase("Jetty-Batch-Supported")) {
            this._remoteRepoUrl = value.toString();
        } else if (name.toString().equalsIgnoreCase("Jetty-Batch-Id")) {
            this._remoteBatchId = value.toString();
        }
    }

    protected void onResponseComplete() {
        try {
            if (this._inputStream != null) {
                this._inputStream.close();
            }
            if (this._status != 200 && this._status != 201 && this._status != 204) {
                this.onFileError(this._url, new HttpClientException(this._binding, "Http status code=" + this._status));
                return;
            }
            if (this._remoteBatchId != null && !this._batchId.equals(this._remoteBatchId)) {
                this.onFileError(this._url, new HttpClientException(this._binding, "Non matching mercury ids. Sent=" + this._batchId + " received=" + this._remoteBatchId));
                return;
            }
            this.onFileComplete(this._url, this._localFile);
        }
        catch (Exception e) {
            this.onFileError(this._url, new HttpClientException(this._binding, e.getLocalizedMessage()));
        }
    }

    private InputStream getInputStream() throws IOException {
        if (this._inputStream == null) {
            InputStream is = null;
            if (this._binding.isFile()) {
                is = new FileInputStream(this._localFile);
            } else if (this._binding.isInMemory()) {
                is = this._binding.getLocalInputStream();
                if (!this.getRetryStatus()) {
                    if (is.markSupported()) {
                        is.mark(1024);
                    }
                } else if (is.markSupported()) {
                    is.reset();
                }
            }
            if (!this.getRetryStatus()) {
                ObservableInputStream ois = new ObservableInputStream(is);
                this._inputStream = ois;
                ois.addObservers(this._observers);
            } else {
                this._inputStream = is;
            }
        }
        return this._inputStream;
    }

    protected void onRetry() throws IOException {
        super.onRetry();
        if (this._inputStream != null) {
            this._inputStream.close();
        }
        this._inputStream = null;
        this.setRequestContent(null);
        this.setRequestContentSource(this.getInputStream());
    }
}

