/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.servlet.PutFilter;
import org.mortbay.util.IO;
import org.mortbay.util.URIUtil;

public abstract class BatchFilter
extends PutFilter {
    protected ConcurrentMap<String, Batch> _batches = new ConcurrentHashMap<String, Batch>();
    protected String _batchIdHeader = "Jetty-Batch-Id";
    protected String _batchSupportedHeader = "Jetty-Batch-Supported";
    protected String _batchCommitHeader = "Jetty-Batch-Commit";
    protected String _batchDiscardHeader = "Jetty-Batch-Discard";

    public abstract boolean commitFiles(HttpServletRequest var1, HttpServletResponse var2, Batch var3) throws Exception;

    public abstract boolean discardFiles(HttpServletRequest var1, HttpServletResponse var2, Batch var3) throws Exception;

    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        String s = config.getInitParameter("batchIdHeader");
        if (s != null) {
            this._batchIdHeader = s;
        }
        if ((s = config.getInitParameter("batchSupportedHeader")) != null) {
            this._batchSupportedHeader = s;
        }
        if ((s = config.getInitParameter("batchCommitHeader")) != null) {
            this._batchCommitHeader = s;
        }
        if ((s = config.getInitParameter("batchDiscardHeader")) != null) {
            this._batchDiscardHeader = s;
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (request.getMethod().equals("GET")) {
            chain.doFilter(req, res);
            return;
        }
        String batchId = request.getHeader(this._batchIdHeader);
        String commitId = request.getHeader(this._batchCommitHeader);
        String discardId = request.getHeader(this._batchDiscardHeader);
        if (batchId == null && commitId == null && discardId == null) {
            super.doFilter(req, res, chain);
            return;
        }
        if (batchId != null) {
            this.handlePut(request, response, batchId);
            return;
        }
        if (discardId != null) {
            this.handleDiscard(request, response, discardId);
            return;
        }
        if (commitId != null) {
            this.handleCommit(request, response, commitId);
            return;
        }
        chain.doFilter(req, res);
    }

    public void handlePut(HttpServletRequest request, HttpServletResponse response, String batchId) throws ServletException, IOException {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String pathInContext = URIUtil.addPaths((String)servletPath, (String)pathInfo);
        String finalResource = URIUtil.addPaths((String)this._baseURI, (String)pathInContext);
        File finalFile = null;
        try {
            finalFile = new File(new URI(finalResource));
            boolean exists = finalFile.exists();
            this.putFile(request, response, pathInContext, batchId);
            Batch batch = this.addBatch(batchId, finalResource);
            String contextPath = this._context.getContextPath();
            if (contextPath.equals("")) {
                contextPath = "/";
            }
            if (!contextPath.endsWith("/")) {
                contextPath = contextPath + "/";
            }
            String commitBatchUrl = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + contextPath;
            response.setHeader(this._batchSupportedHeader, commitBatchUrl);
            response.setStatus(exists ? 200 : 201);
            response.flushBuffer();
        }
        catch (Exception ex) {
            this._context.log(ex.toString(), (Throwable)ex);
            response.sendError(403);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDiscard(HttpServletRequest request, HttpServletResponse response, String batchId) throws ServletException, IOException {
        boolean ok = true;
        try {
            ok = this.discardFiles(request, response, (Batch)this._batches.get(batchId));
            response.setStatus(ok ? 200 : 500);
            response.flushBuffer();
        }
        catch (Exception ex) {
            this._context.log(ex.toString(), (Throwable)ex);
            response.sendError(500);
        }
        finally {
            this.updateBatch(batchId, ok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommit(HttpServletRequest request, HttpServletResponse response, String batchId) throws ServletException, IOException {
        boolean ok = true;
        try {
            ok = this.commitFiles(request, response, (Batch)this._batches.get(batchId));
            response.setStatus(ok ? 200 : 500);
            response.flushBuffer();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._context.log(ex.toString(), (Throwable)ex);
            response.sendError(500);
        }
        finally {
            this.updateBatch(batchId, ok);
        }
    }

    public void putFile(HttpServletRequest request, HttpServletResponse response, String pathInContext, String batchId) throws Exception {
        String finalResource = URIUtil.addPaths((String)this._baseURI, (String)pathInContext);
        File finalFile = null;
        finalFile = new File(new URI(finalResource));
        File parent = finalFile.getParentFile();
        parent.mkdirs();
        int toRead = request.getContentLength();
        ServletInputStream in = request.getInputStream();
        FileOutputStream out = new FileOutputStream(finalFile, false);
        if (toRead >= 0) {
            IO.copy((InputStream)in, (OutputStream)out, (long)toRead);
        } else {
            IO.copy((InputStream)in, (OutputStream)out);
        }
    }

    protected Batch addBatch(String batchId, String file) {
        Batch status = (Batch)this._batches.get(batchId);
        long timestamp = System.currentTimeMillis();
        if (status == null) {
            status = new Batch(batchId, timestamp);
            this._batches.put(batchId, status);
        }
        status.addFile(file);
        return status;
    }

    protected void updateBatch(String batchId, boolean ok) {
        Batch status = (Batch)this._batches.get(batchId);
        if (status == null) {
            this._context.log("Unknown mercury id to update: " + batchId);
        } else if (ok) {
            this._batches.remove(batchId);
        } else {
            status.failed();
        }
    }

    protected class Batch {
        protected String _batchId;
        protected long _timestamp;
        protected boolean _ok;
        protected List<String> _files;

        public Batch(String batchId, long timestamp) {
            this._batchId = batchId;
            this._timestamp = timestamp;
            this._files = new ArrayList<String>();
        }

        public String getBatchId() {
            return this._batchId;
        }

        public void addFile(String file) {
            this._files.add(file);
        }

        public List getFiles() {
            return this._files;
        }

        public void failed() {
            this._ok = false;
        }

        public boolean isOK() {
            return this._ok;
        }

        public long getTimestamp() {
            return this._timestamp;
        }

        public String toString() {
            return "BatchStatus: id=" + this._batchId + " ts=" + this._timestamp + " count=" + this._files.size() + ", " + this._ok;
        }
    }
}

