/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.testing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.testing.ConfigurationException;
import org.apache.maven.plugin.testing.ResolverExpressionEvaluatorStub;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public abstract class AbstractMojoTestCase
extends PlexusTestCase {
    private ComponentConfigurator configurator;
    private PlexusContainer container;

    protected void setUp() throws Exception {
        this.configurator = (ComponentConfigurator)this.getContainer().lookup(ComponentConfigurator.class, "basic");
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + this.getPluginDescriptorLocation());
        XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)is);
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)new BufferedReader((Reader)reader), this.container.getContext().getContextData());
        PluginDescriptor pluginDescriptor = new PluginDescriptorBuilder().build((Reader)interpolationFilterReader);
        for (ComponentDescriptor desc : pluginDescriptor.getComponents()) {
            this.getContainer().addComponentDescriptor(desc);
        }
    }

    protected InputStream getPublicDescriptorStream() throws Exception {
        return new FileInputStream(new File(this.getPluginDescriptorPath()));
    }

    protected String getPluginDescriptorPath() {
        return AbstractMojoTestCase.getBasedir() + "/target/classes/META-INF/maven/plugin.xml";
    }

    protected String getPluginDescriptorLocation() {
        return "META-INF/maven/plugin.xml";
    }

    protected void setupContainer() {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(classWorld).setName("embedder");
        try {
            this.container = new DefaultPlexusContainer(cc);
        }
        catch (PlexusContainerException e) {
            e.printStackTrace();
            AbstractMojoTestCase.fail((String)"Failed to create plexus container.");
        }
    }

    protected PlexusContainer getContainer() {
        if (this.container == null) {
            this.setupContainer();
        }
        return this.container;
    }

    protected Mojo lookupMojo(String goal, String pluginPom) throws Exception {
        return this.lookupMojo(goal, new File(pluginPom));
    }

    protected Mojo lookupEmptyMojo(String goal, String pluginPom) throws Exception {
        return this.lookupEmptyMojo(goal, new File(pluginPom));
    }

    protected Mojo lookupMojo(String goal, File pom) throws Exception {
        File pluginPom = new File(AbstractMojoTestCase.getBasedir(), "pom.xml");
        Xpp3Dom pluginPomDom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((File)pluginPom));
        String artifactId = pluginPomDom.getChild("artifactId").getValue();
        String groupId = this.resolveFromRootThenParent(pluginPomDom, "groupId");
        String version = this.resolveFromRootThenParent(pluginPomDom, "version");
        PlexusConfiguration pluginConfiguration = this.extractPluginConfiguration(artifactId, pom);
        return this.lookupMojo(groupId, artifactId, version, goal, pluginConfiguration);
    }

    protected Mojo lookupEmptyMojo(String goal, File pom) throws Exception {
        File pluginPom = new File(AbstractMojoTestCase.getBasedir(), "pom.xml");
        Xpp3Dom pluginPomDom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((File)pluginPom));
        String artifactId = pluginPomDom.getChild("artifactId").getValue();
        String groupId = this.resolveFromRootThenParent(pluginPomDom, "groupId");
        String version = this.resolveFromRootThenParent(pluginPomDom, "version");
        return this.lookupMojo(groupId, artifactId, version, goal, null);
    }

    protected Mojo lookupMojo(String groupId, String artifactId, String version, String goal, PlexusConfiguration pluginConfiguration) throws Exception {
        this.validateContainerStatus();
        Mojo mojo = (Mojo)this.lookup(Mojo.ROLE, groupId + ":" + artifactId + ":" + version + ":" + goal);
        LoggerManager loggerManager = (LoggerManager)this.getContainer().lookup(LoggerManager.class);
        DefaultLog mojoLogger = new DefaultLog(loggerManager.getLoggerForComponent(Mojo.ROLE));
        mojo.setLog((Log)mojoLogger);
        if (pluginConfiguration != null) {
            ResolverExpressionEvaluatorStub evaluator = new ResolverExpressionEvaluatorStub();
            this.configurator.configureComponent((Object)mojo, pluginConfiguration, (ExpressionEvaluator)evaluator, this.getContainer().getContainerRealm());
        }
        return mojo;
    }

    protected PlexusConfiguration extractPluginConfiguration(String artifactId, File pom) throws Exception {
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)pom);
        Xpp3Dom pomDom = Xpp3DomBuilder.build((Reader)reader);
        return this.extractPluginConfiguration(artifactId, pomDom);
    }

    protected PlexusConfiguration extractPluginConfiguration(String artifactId, Xpp3Dom pomDom) throws Exception {
        Xpp3Dom pluginsRootElement;
        Xpp3Dom pluginConfigurationElement = null;
        Xpp3Dom buildElement = pomDom.getChild("build");
        if (buildElement != null && (pluginsRootElement = buildElement.getChild("plugins")) != null) {
            Xpp3Dom[] pluginElements = pluginsRootElement.getChildren();
            for (int i = 0; i < pluginElements.length; ++i) {
                Xpp3Dom pluginElement = pluginElements[i];
                String pluginElementArtifactId = pluginElement.getChild("artifactId").getValue();
                if (!pluginElementArtifactId.equals(artifactId)) continue;
                pluginConfigurationElement = pluginElement.getChild("configuration");
                break;
            }
            if (pluginConfigurationElement == null) {
                throw new ConfigurationException("Cannot find a configuration element for a plugin with an artifactId of " + artifactId + ".");
            }
        }
        if (pluginConfigurationElement == null) {
            throw new ConfigurationException("Cannot find a configuration element for a plugin with an artifactId of " + artifactId + ".");
        }
        return new XmlPlexusConfiguration(pluginConfigurationElement);
    }

    protected Mojo configureMojo(Mojo mojo, String artifactId, File pom) throws Exception {
        this.validateContainerStatus();
        PlexusConfiguration pluginConfiguration = this.extractPluginConfiguration(artifactId, pom);
        ResolverExpressionEvaluatorStub evaluator = new ResolverExpressionEvaluatorStub();
        this.configurator.configureComponent((Object)mojo, pluginConfiguration, (ExpressionEvaluator)evaluator, this.getContainer().getContainerRealm());
        return mojo;
    }

    protected Mojo configureMojo(Mojo mojo, PlexusConfiguration pluginConfiguration) throws Exception {
        this.validateContainerStatus();
        ResolverExpressionEvaluatorStub evaluator = new ResolverExpressionEvaluatorStub();
        this.configurator.configureComponent((Object)mojo, pluginConfiguration, (ExpressionEvaluator)evaluator, this.getContainer().getContainerRealm());
        return mojo;
    }

    protected Object getVariableValueFromObject(Object object, String variable) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        field.setAccessible(true);
        return field.get(object);
    }

    protected Map getVariablesAndValuesFromObject(Object object) throws IllegalAccessException {
        return this.getVariablesAndValuesFromObject(object.getClass(), object);
    }

    protected Map getVariablesAndValuesFromObject(Class clazz, Object object) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (int i = 0; i < fields.length; ++i) {
            AccessibleObject field = fields[i];
            map.put(((Field)field).getName(), ((Field)field).get(object));
        }
        Class superclass = clazz.getSuperclass();
        if (!Object.class.equals(superclass)) {
            map.putAll(this.getVariablesAndValuesFromObject(superclass, object));
        }
        return map;
    }

    protected void setVariableValueToObject(Object object, String variable, Object value) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        field.setAccessible(true);
        field.set(object, value);
    }

    private String resolveFromRootThenParent(Xpp3Dom pluginPomDom, String element) throws Exception {
        Xpp3Dom elementDom = pluginPomDom.getChild(element);
        if (elementDom == null) {
            Xpp3Dom pluginParentDom = pluginPomDom.getChild("parent");
            if (pluginParentDom != null) {
                elementDom = pluginParentDom.getChild(element);
                if (elementDom == null) {
                    throw new Exception("unable to determine " + element);
                }
                return elementDom.getValue();
            }
            throw new Exception("unable to determine " + element);
        }
        return elementDom.getValue();
    }

    private void validateContainerStatus() throws Exception {
        if (this.getContainer() != null) {
            return;
        }
        throw new Exception("container is null, make sure super.setUp() is called");
    }
}

