/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystemSession;

public class DefaultPluginToolsRequest
implements PluginToolsRequest {
    private static final String DEFAULT_ENCODING = ReaderFactory.FILE_ENCODING;
    private PluginDescriptor pluginDescriptor;
    private MavenProject project;
    private String encoding = DEFAULT_ENCODING;
    private boolean skipErrorNoDescriptorsFound;
    private Set<Artifact> dependencies;
    private RepositorySystemSession repoSession;
    private URI internalJavadocBaseUrl;
    private String internalJavadocVersion;
    private List<URI> externalJavadocBaseUrls;
    private Settings settings;
    private String requiredJavaVersion;
    private String mavenApiVersion;

    public DefaultPluginToolsRequest(MavenProject project, PluginDescriptor pluginDescriptor) {
        this.project = project;
        this.pluginDescriptor = pluginDescriptor;
    }

    @Override
    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    @Override
    public PluginToolsRequest setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.pluginDescriptor = pluginDescriptor;
        return this;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public PluginToolsRequest setProject(MavenProject project) {
        this.project = project;
        return this;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public PluginToolsRequest setEncoding(String encoding) {
        this.encoding = StringUtils.isNotEmpty((String)encoding) ? encoding : DEFAULT_ENCODING;
        return this;
    }

    @Override
    public boolean isSkipErrorNoDescriptorsFound() {
        return this.skipErrorNoDescriptorsFound;
    }

    @Override
    public PluginToolsRequest setSkipErrorNoDescriptorsFound(boolean skipErrorNoDescriptorsFound) {
        this.skipErrorNoDescriptorsFound = skipErrorNoDescriptorsFound;
        return this;
    }

    @Override
    public Set<Artifact> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new HashSet<Artifact>();
        }
        return this.dependencies;
    }

    @Override
    public PluginToolsRequest setDependencies(Set<Artifact> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    @Override
    public RepositorySystemSession getRepoSession() {
        return this.repoSession;
    }

    @Override
    public void setRepoSession(RepositorySystemSession repoSession) {
        this.repoSession = repoSession;
    }

    @Override
    public PluginToolsRequest setInternalJavadocBaseUrl(URI baseUrl) {
        this.internalJavadocBaseUrl = baseUrl;
        return this;
    }

    @Override
    public URI getInternalJavadocBaseUrl() {
        return this.internalJavadocBaseUrl;
    }

    @Override
    public PluginToolsRequest setInternalJavadocVersion(String javadocVersion) {
        this.internalJavadocVersion = javadocVersion;
        return this;
    }

    @Override
    public String getInternalJavadocVersion() {
        return this.internalJavadocVersion;
    }

    @Override
    public PluginToolsRequest setExternalJavadocBaseUrls(List<URI> javadocLinks) {
        this.externalJavadocBaseUrls = javadocLinks;
        return this;
    }

    @Override
    public List<URI> getExternalJavadocBaseUrls() {
        return this.externalJavadocBaseUrls;
    }

    @Override
    public PluginToolsRequest setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public PluginToolsRequest setRequiredJavaVersion(String requiredJavaVersion) {
        this.requiredJavaVersion = requiredJavaVersion;
        return this;
    }

    @Override
    public String getRequiredJavaVersion() {
        return this.requiredJavaVersion;
    }

    @Override
    public PluginToolsRequest setUsedMavenApiVersion(String mavenApiVersion) {
        this.mavenApiVersion = mavenApiVersion;
        return this;
    }

    @Override
    public String getUsedMavenApiVersion() {
        return this.mavenApiVersion;
    }
}

