/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class PluginUtil {
    private static final String NEXUS_STAGING = "nexus-staging";

    PluginUtil() {
    }

    static boolean isSkip(MavenProject project) {
        return PluginUtil.isSkip(project, "install") || PluginUtil.isSkip(project, "deploy") || PluginUtil.isSkip(project, NEXUS_STAGING);
    }

    private static boolean isSkip(MavenProject project, String id) {
        String pluginProperty;
        String pluginParameter;
        String pluginGa;
        if (id.equals(NEXUS_STAGING)) {
            pluginGa = "org.sonatype.plugins:" + id + "-maven-plugin";
            pluginParameter = "skipNexusStagingDeployMojo";
            pluginProperty = "skipNexusStagingDeployMojo";
        } else {
            pluginGa = "org.apache.maven.plugins:maven-" + id + "-plugin";
            pluginParameter = "skip";
            pluginProperty = "maven." + id + ".skip";
        }
        Plugin plugin = PluginUtil.getPlugin(project, pluginGa);
        String skip = PluginUtil.getPluginParameter(plugin, pluginParameter);
        if (skip == null) {
            skip = project.getProperties().getProperty(pluginProperty);
        }
        return Boolean.parseBoolean(skip);
    }

    private static Plugin getPlugin(MavenProject project, String plugin) {
        Map pluginsAsMap = project.getBuild().getPluginsAsMap();
        Plugin result = (Plugin)pluginsAsMap.get(plugin);
        if (result == null) {
            pluginsAsMap = project.getPluginManagement().getPluginsAsMap();
            result = (Plugin)pluginsAsMap.get(plugin);
        }
        return result;
    }

    private static String getPluginParameter(Plugin plugin, String parameter) {
        Xpp3Dom target;
        Xpp3Dom pluginConf;
        if (plugin != null && (pluginConf = (Xpp3Dom)plugin.getConfiguration()) != null && (target = pluginConf.getChild(parameter)) != null) {
            return target.getValue();
        }
        return null;
    }
}

