/*
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 1.4.1 on 2012-11-15 00:02:59,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.plugin.assembly.model;

/**
 * 
 *         
 *         Defines a Maven repository to be included in the
 * assembly. The artifacts
 *         available to be included in a repository are your
 * project's dependency
 *         artifacts. The repository created contains the needed
 * metadata entries
 *         and also contains both sha1 and md5 checksums. This is
 * useful for creating
 *         archives which will be deployed to internal
 * repositories.
 * 
 *         <br/><b>NOTE:</b> Currently, only artifacts from the
 * central repository
 *         are allowed.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Repository
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             Sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory,
     *             directly beneath the root of the archive.
     *           
     */
    private String outputDirectory;

    /**
     * Field includes.
     */
    private java.util.List<String> includes;

    /**
     * Field excludes.
     */
    private java.util.List<String> excludes;

    /**
     * 
     *             
     *             Similar to a UNIX permission, sets the file mode
     * of the files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *             
     *           
     */
    private String fileMode;

    /**
     * 
     *             
     *             Similar to a UNIX permission, sets the directory
     * mode of the directories
     *             included. 
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *             
     *           
     */
    private String directoryMode;

    /**
     * 
     *             If set to true, this property will trigger the
     * creation of repository
     *             metadata which will allow the repository to be
     * used as a functional remote
     *             repository. Default value is false.
     *           
     */
    private boolean includeMetadata = false;

    /**
     * Field groupVersionAlignments.
     */
    private java.util.List<GroupVersionAlignment> groupVersionAlignments;

    /**
     * 
     *             Specifies the scope for artifacts included in
     * this repository.
     *             Default scope value is "runtime". (Since 2.2)
     *           .
     */
    private String scope = "runtime";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude.
     * 
     * @param string
     */
    public void addExclude( String string )
    {
        getExcludes().add( string );
    } //-- void addExclude( String )

    /**
     * Method addGroupVersionAlignment.
     * 
     * @param groupVersionAlignment
     */
    public void addGroupVersionAlignment( GroupVersionAlignment groupVersionAlignment )
    {
        getGroupVersionAlignments().add( groupVersionAlignment );
    } //-- void addGroupVersionAlignment( GroupVersionAlignment )

    /**
     * Method addInclude.
     * 
     * @param string
     */
    public void addInclude( String string )
    {
        getIncludes().add( string );
    } //-- void addInclude( String )

    /**
     * Get similar to a UNIX permission, sets the directory mode of
     * the directories
     *             included. 
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @return String
     */
    public String getDirectoryMode()
    {
        return this.directoryMode;
    } //-- String getDirectoryMode()

    /**
     * Method getExcludes.
     * 
     * @return List
     */
    public java.util.List<String> getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList<String>();
        }

        return this.excludes;
    } //-- java.util.List<String> getExcludes()

    /**
     * Get similar to a UNIX permission, sets the file mode of the
     * files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @return String
     */
    public String getFileMode()
    {
        return this.fileMode;
    } //-- String getFileMode()

    /**
     * Method getGroupVersionAlignments.
     * 
     * @return List
     */
    public java.util.List<GroupVersionAlignment> getGroupVersionAlignments()
    {
        if ( this.groupVersionAlignments == null )
        {
            this.groupVersionAlignments = new java.util.ArrayList<GroupVersionAlignment>();
        }

        return this.groupVersionAlignments;
    } //-- java.util.List<GroupVersionAlignment> getGroupVersionAlignments()

    /**
     * Method getIncludes.
     * 
     * @return List
     */
    public java.util.List<String> getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList<String>();
        }

        return this.includes;
    } //-- java.util.List<String> getIncludes()

    /**
     * Get sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory,
     *             directly beneath the root of the archive.
     * 
     * @return String
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory()

    /**
     * Get specifies the scope for artifacts included in this
     * repository.
     *             Default scope value is "runtime". (Since 2.2).
     * 
     * @return String
     */
    public String getScope()
    {
        return this.scope;
    } //-- String getScope()

    /**
     * Get if set to true, this property will trigger the creation
     * of repository
     *             metadata which will allow the repository to be
     * used as a functional remote
     *             repository. Default value is false.
     * 
     * @return boolean
     */
    public boolean isIncludeMetadata()
    {
        return this.includeMetadata;
    } //-- boolean isIncludeMetadata()

    /**
     * Method removeExclude.
     * 
     * @param string
     */
    public void removeExclude( String string )
    {
        getExcludes().remove( string );
    } //-- void removeExclude( String )

    /**
     * Method removeGroupVersionAlignment.
     * 
     * @param groupVersionAlignment
     */
    public void removeGroupVersionAlignment( GroupVersionAlignment groupVersionAlignment )
    {
        getGroupVersionAlignments().remove( groupVersionAlignment );
    } //-- void removeGroupVersionAlignment( GroupVersionAlignment )

    /**
     * Method removeInclude.
     * 
     * @param string
     */
    public void removeInclude( String string )
    {
        getIncludes().remove( string );
    } //-- void removeInclude( String )

    /**
     * Set similar to a UNIX permission, sets the directory mode of
     * the directories
     *             included. 
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @param directoryMode
     */
    public void setDirectoryMode( String directoryMode )
    {
        this.directoryMode = directoryMode;
    } //-- void setDirectoryMode( String )

    /**
     * Set when &lt;exclude&gt; subelements are present, they
     * define a set of
     *             dependency artifact coordinates to exclude. If
     * none is present, then
     *             &lt;excludes&gt; represents no exclusions.
     * 
     *             Artifact coordinates may be given in simple
     * groupId:artifactId form,
     *             or they may be fully qualified in the form
     * groupId:artifactId:type[:classifier]:version.
     *             Additionally, wildcards can be used, as in
     * *:maven-*.
     * 
     * @param excludes
     */
    public void setExcludes( java.util.List<String> excludes )
    {
        this.excludes = excludes;
    } //-- void setExcludes( java.util.List )

    /**
     * Set similar to a UNIX permission, sets the file mode of the
     * files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @param fileMode
     */
    public void setFileMode( String fileMode )
    {
        this.fileMode = fileMode;
    } //-- void setFileMode( String )

    /**
     * Set specifies that you want to align a group of artifacts to
     * a specified
     *             version. A groupVersionAlignment is specified by
     * providing one or
     *             more of &lt;groupVersionAlignment&gt;
     * subelements.
     * 
     * @param groupVersionAlignments
     */
    public void setGroupVersionAlignments( java.util.List<GroupVersionAlignment> groupVersionAlignments )
    {
        this.groupVersionAlignments = groupVersionAlignments;
    } //-- void setGroupVersionAlignments( java.util.List )

    /**
     * Set if set to true, this property will trigger the creation
     * of repository
     *             metadata which will allow the repository to be
     * used as a functional remote
     *             repository. Default value is false.
     * 
     * @param includeMetadata
     */
    public void setIncludeMetadata( boolean includeMetadata )
    {
        this.includeMetadata = includeMetadata;
    } //-- void setIncludeMetadata( boolean )

    /**
     * Set when &lt;include&gt; subelements are present, they
     * define a set of
     *             artifact coordinates to include. If none is
     * present, then
     *             &lt;includes&gt; represents all valid values.
     * 
     *             Artifact coordinates may be given in simple
     * groupId:artifactId form,
     *             or they may be fully qualified in the form
     * groupId:artifactId:type[:classifier]:version.
     *             Additionally, wildcards can be used, as in
     * *:maven-*.
     * 
     * @param includes
     */
    public void setIncludes( java.util.List<String> includes )
    {
        this.includes = includes;
    } //-- void setIncludes( java.util.List )

    /**
     * Set sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory,
     *             directly beneath the root of the archive.
     * 
     * @param outputDirectory
     */
    public void setOutputDirectory( String outputDirectory )
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory( String )

    /**
     * Set specifies the scope for artifacts included in this
     * repository.
     *             Default scope value is "runtime". (Since 2.2).
     * 
     * @param scope
     */
    public void setScope( String scope )
    {
        this.scope = scope;
    } //-- void setScope( String )

}
