/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.plugins.assembly.filter.ContainerDescriptorHandler;
import org.apache.maven.plugins.assembly.utils.AssemblyFileUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.util.IOUtil;

abstract class AbstractLineAggregatingHandler
implements ContainerDescriptorHandler {
    private Map<String, List<String>> catalog = new HashMap<String, List<String>>();
    private boolean excludeOverride = false;

    AbstractLineAggregatingHandler() {
    }

    protected abstract String getOutputPathPrefix(FileInfo var1);

    protected abstract boolean fileMatches(FileInfo var1);

    String getEncoding() {
        return "UTF-8";
    }

    public void finalizeArchiveCreation(Archiver archiver) {
        ResourceIterator it = archiver.getResources();
        while (it.hasNext()) {
            it.next();
        }
        this.addToArchive(archiver);
    }

    void addToArchive(Archiver archiver) {
        for (Map.Entry<String, List<String>> entry : this.catalog.entrySet()) {
            File f;
            String name = entry.getKey();
            String fname = new File(name).getName();
            PrintWriter writer = null;
            try {
                f = File.createTempFile("assembly-" + fname, ".tmp");
                f.deleteOnExit();
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), this.getEncoding()));
                for (String line : entry.getValue()) {
                    writer.println(line);
                }
            }
            catch (IOException e) {
                try {
                    throw new ArchiverException("Error adding aggregated content for: " + fname + " to finalize archive creation. Reason: " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
            }
            IOUtil.close((Writer)writer);
            this.excludeOverride = true;
            archiver.addFile(f, name);
            this.excludeOverride = false;
        }
    }

    public void finalizeArchiveExtraction(UnArchiver unArchiver) {
    }

    public List<String> getVirtualFiles() {
        return new ArrayList<String>(this.catalog.keySet());
    }

    public boolean isSelected(@Nonnull FileInfo fileInfo) throws IOException {
        if (this.excludeOverride) {
            return true;
        }
        String name = AssemblyFileUtils.normalizeFileInfo(fileInfo);
        if (fileInfo.isFile() && this.fileMatches(fileInfo)) {
            name = this.getOutputPathPrefix(fileInfo) + new File(name).getName();
            List<String> lines = this.catalog.get(name);
            if (lines == null) {
                lines = new ArrayList<String>();
                this.catalog.put(name, lines);
            }
            this.readLines(fileInfo, lines);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readLines(FileInfo fileInfo, List<String> lines) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(fileInfo.getContents(), this.getEncoding()));
            while ((line = reader.readLine()) != null) {
                if (lines.contains(line)) continue;
                lines.add(line);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((Reader)reader);
    }

    protected final Map<String, List<String>> getCatalog() {
        return this.catalog;
    }

    protected final void setCatalog(Map<String, List<String>> catalog) {
        this.catalog = catalog;
    }
}

