/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.5.1,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.plugins.assembly.model;

/**
 * 
 *         A dependencySet allows inclusion and exclusion of
 * project dependencies
 *         in the assembly.
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class DependencySet
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             Sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory,
     *             directly beneath the root of the archive.
     *           
     */
    private String outputDirectory;

    /**
     * Field includes.
     */
    private java.util.List<String> includes;

    /**
     * Field excludes.
     */
    private java.util.List<String> excludes;

    /**
     * 
     *             
     *             Similar to a UNIX permission, sets the file mode
     * of the files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only. The default value is 0644.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *             
     *           
     */
    private String fileMode;

    /**
     * 
     *             
     *             Similar to a UNIX permission, sets the directory
     * mode of the directories
     *             included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only. The default value is 0755.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *             
     *           
     */
    private String directoryMode;

    /**
     * 
     *           When specified as true, any include/exclude
     * patterns which aren't used to filter an actual
     *           artifact during assembly creation will cause the
     * build to fail with an error. This is meant
     *           to highlight obsolete inclusions or exclusions, or
     * else signal that the assembly descriptor
     *           is incorrectly configured. (Since 2.2)
     *           .
     */
    private boolean useStrictFiltering = false;

    /**
     * 
     *             Sets the mapping pattern for all dependencies
     * included in this
     *             assembly. Default is
     * ${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}.
     *             (Since 2.2-beta-2; 2.2-beta-1 uses
     * ${artifactId}-${version}${dashClassifier?}.${extension}).
     *             NOTE: If the dependencySet specifies unpack ==
     * true, outputFileNameMapping WILL NOT BE USED; in these
     * cases,
     *             use outputDirectory.
     *             See the plugin FAQ for more details about
     * entries usable in the outputFileNameMapping parameter.
     *           
     */
    private String outputFileNameMapping = "${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}";

    /**
     * 
     *             If set to true, this property will unpack all
     * dependencies
     *             into the specified output directory. When set to
     * false,
     *             dependencies will be included as archives
     * (jars). Can only unpack
     *             jar, zip, tar.gz, and tar.bz archives. Default
     * value is false.
     *           
     */
    private boolean unpack = false;

    /**
     * 
     *           Allows the specification of includes and excludes,
     * along with filtering options, for items
     *           unpacked from a dependency artifact. (Since 2.2)
     *           .
     */
    private UnpackOptions unpackOptions;

    /**
     * 
     *             Sets the dependency scope for this
     * dependencySet.
     *             Default scope value is "runtime".
     *           
     */
    private String scope = "runtime";

    /**
     * 
     *           Determines whether the artifact produced during
     * the current project's
     *           build should be included in this dependency set.
     * Default value is true,
     *           for backward compatibility. (Since 2.2)
     *           .
     */
    private boolean useProjectArtifact = true;

    /**
     * 
     *           Determines whether the attached artifacts produced
     * during the current project's
     *           build should be included in this dependency set.
     * Default value is false. (Since 2.2)
     *           .
     */
    private boolean useProjectAttachments = false;

    /**
     * 
     *           Determines whether transitive dependencies will be
     * included in the processing of
     *           the current dependency set. If true,
     * includes/excludes/useTransitiveFiltering
     *           will apply to transitive dependency artifacts in
     * addition to the main project
     *           dependency artifacts. If false,
     * useTransitiveFiltering is meaningless, and
     *           includes/excludes only affect the immediate
     * dependencies of the project.
     *           By default, this value is true. (Since 2.2)
     *           .
     */
    private boolean useTransitiveDependencies = true;

    /**
     * 
     *           Determines whether the include/exclude patterns in
     * this dependency set will be applied to
     *           the transitive path of a given artifact. If true,
     * and the current artifact is a transitive
     *           dependency brought in by another artifact which
     * matches an inclusion or exclusion pattern,
     *           then the current artifact has the same
     * inclusion/exclusion logic applied to it as well. By
     *           default, this value is false, in order to preserve
     * backward compatibility with version 2.1.
     *           This means that includes/excludes only apply
     * directly to the current artifact, and not to
     *           the transitive set of artifacts which brought it
     * in. (Since 2.2)
     *           .
     */
    private boolean useTransitiveFiltering = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude.
     * 
     * @param string a string object.
     */
    public void addExclude( String string )
    {
        getExcludes().add( string );
    } //-- void addExclude( String )

    /**
     * Method addInclude.
     * 
     * @param string a string object.
     */
    public void addInclude( String string )
    {
        getIncludes().add( string );
    } //-- void addInclude( String )

    /**
     * Get similar to a UNIX permission, sets the directory mode of
     * the directories
     *             included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only. The default value is 0755.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @return String
     */
    public String getDirectoryMode()
    {
        return this.directoryMode;
    } //-- String getDirectoryMode()

    /**
     * Method getExcludes.
     * 
     * @return List
     */
    public java.util.List<String> getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList<String>();
        }

        return this.excludes;
    } //-- java.util.List<String> getExcludes()

    /**
     * Get similar to a UNIX permission, sets the file mode of the
     * files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only. The default value is 0644.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @return String
     */
    public String getFileMode()
    {
        return this.fileMode;
    } //-- String getFileMode()

    /**
     * Method getIncludes.
     * 
     * @return List
     */
    public java.util.List<String> getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList<String>();
        }

        return this.includes;
    } //-- java.util.List<String> getIncludes()

    /**
     * Get sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory,
     *             directly beneath the root of the archive.
     * 
     * @return String
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory()

    /**
     * Get sets the mapping pattern for all dependencies included
     * in this
     *             assembly. Default is
     * ${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}.
     *             (Since 2.2-beta-2; 2.2-beta-1 uses
     * ${artifactId}-${version}${dashClassifier?}.${extension}).
     *             NOTE: If the dependencySet specifies unpack ==
     * true, outputFileNameMapping WILL NOT BE USED; in these
     * cases,
     *             use outputDirectory.
     *             See the plugin FAQ for more details about
     * entries usable in the outputFileNameMapping parameter.
     * 
     * @return String
     */
    public String getOutputFileNameMapping()
    {
        return this.outputFileNameMapping;
    } //-- String getOutputFileNameMapping()

    /**
     * Get sets the dependency scope for this dependencySet.
     *             Default scope value is "runtime".
     * 
     * @return String
     */
    public String getScope()
    {
        return this.scope;
    } //-- String getScope()

    /**
     * Get allows the specification of includes and excludes, along
     * with filtering options, for items
     *           unpacked from a dependency artifact. (Since 2.2).
     * 
     * @return UnpackOptions
     */
    public UnpackOptions getUnpackOptions()
    {
        return this.unpackOptions;
    } //-- UnpackOptions getUnpackOptions()

    /**
     * Get if set to true, this property will unpack all
     * dependencies
     *             into the specified output directory. When set to
     * false,
     *             dependencies will be included as archives
     * (jars). Can only unpack
     *             jar, zip, tar.gz, and tar.bz archives. Default
     * value is false.
     * 
     * @return boolean
     */
    public boolean isUnpack()
    {
        return this.unpack;
    } //-- boolean isUnpack()

    /**
     * Get determines whether the artifact produced during the
     * current project's
     *           build should be included in this dependency set.
     * Default value is true,
     *           for backward compatibility. (Since 2.2).
     * 
     * @return boolean
     */
    public boolean isUseProjectArtifact()
    {
        return this.useProjectArtifact;
    } //-- boolean isUseProjectArtifact()

    /**
     * Get determines whether the attached artifacts produced
     * during the current project's
     *           build should be included in this dependency set.
     * Default value is false. (Since 2.2).
     * 
     * @return boolean
     */
    public boolean isUseProjectAttachments()
    {
        return this.useProjectAttachments;
    } //-- boolean isUseProjectAttachments()

    /**
     * Get when specified as true, any include/exclude patterns
     * which aren't used to filter an actual
     *           artifact during assembly creation will cause the
     * build to fail with an error. This is meant
     *           to highlight obsolete inclusions or exclusions, or
     * else signal that the assembly descriptor
     *           is incorrectly configured. (Since 2.2).
     * 
     * @return boolean
     */
    public boolean isUseStrictFiltering()
    {
        return this.useStrictFiltering;
    } //-- boolean isUseStrictFiltering()

    /**
     * Get determines whether transitive dependencies will be
     * included in the processing of
     *           the current dependency set. If true,
     * includes/excludes/useTransitiveFiltering
     *           will apply to transitive dependency artifacts in
     * addition to the main project
     *           dependency artifacts. If false,
     * useTransitiveFiltering is meaningless, and
     *           includes/excludes only affect the immediate
     * dependencies of the project.
     *           By default, this value is true. (Since 2.2).
     * 
     * @return boolean
     */
    public boolean isUseTransitiveDependencies()
    {
        return this.useTransitiveDependencies;
    } //-- boolean isUseTransitiveDependencies()

    /**
     * Get determines whether the include/exclude patterns in this
     * dependency set will be applied to
     *           the transitive path of a given artifact. If true,
     * and the current artifact is a transitive
     *           dependency brought in by another artifact which
     * matches an inclusion or exclusion pattern,
     *           then the current artifact has the same
     * inclusion/exclusion logic applied to it as well. By
     *           default, this value is false, in order to preserve
     * backward compatibility with version 2.1.
     *           This means that includes/excludes only apply
     * directly to the current artifact, and not to
     *           the transitive set of artifacts which brought it
     * in. (Since 2.2).
     * 
     * @return boolean
     */
    public boolean isUseTransitiveFiltering()
    {
        return this.useTransitiveFiltering;
    } //-- boolean isUseTransitiveFiltering()

    /**
     * Method removeExclude.
     * 
     * @param string a string object.
     */
    public void removeExclude( String string )
    {
        getExcludes().remove( string );
    } //-- void removeExclude( String )

    /**
     * Method removeInclude.
     * 
     * @param string a string object.
     */
    public void removeInclude( String string )
    {
        getIncludes().remove( string );
    } //-- void removeInclude( String )

    /**
     * Set similar to a UNIX permission, sets the directory mode of
     * the directories
     *             included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only. The default value is 0755.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @param directoryMode a directoryMode object.
     */
    public void setDirectoryMode( String directoryMode )
    {
        this.directoryMode = directoryMode;
    } //-- void setDirectoryMode( String )

    /**
     * Set when &lt;exclude&gt; subelements are present, they
     * define a set of
     *             dependency artifact coordinates to exclude. If
     * none is present, then
     *             &lt;excludes&gt; represents no exclusions.
     * 
     *             Artifact coordinates may be given in simple
     * groupId:artifactId form,
     *             or they may be fully qualified in the form
     * groupId:artifactId:type[:classifier]:version.
     *             Additionally, wildcards can be used, as in
     * *:maven-*.
     * 
     * @param excludes a excludes object.
     */
    public void setExcludes( java.util.List<String> excludes )
    {
        this.excludes = excludes;
    } //-- void setExcludes( java.util.List )

    /**
     * Set similar to a UNIX permission, sets the file mode of the
     * files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only. The default value is 0644.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @param fileMode a fileMode object.
     */
    public void setFileMode( String fileMode )
    {
        this.fileMode = fileMode;
    } //-- void setFileMode( String )

    /**
     * Set when &lt;include&gt; subelements are present, they
     * define a set of
     *             artifact coordinates to include. If none is
     * present, then
     *             &lt;includes&gt; represents all valid values.
     * 
     *             Artifact coordinates may be given in simple
     * groupId:artifactId form,
     *             or they may be fully qualified in the form
     * groupId:artifactId:type[:classifier]:version.
     *             Additionally, wildcards can be used, as in
     * *:maven-*.
     * 
     * @param includes a includes object.
     */
    public void setIncludes( java.util.List<String> includes )
    {
        this.includes = includes;
    } //-- void setIncludes( java.util.List )

    /**
     * Set sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory,
     *             directly beneath the root of the archive.
     * 
     * @param outputDirectory a outputDirectory object.
     */
    public void setOutputDirectory( String outputDirectory )
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory( String )

    /**
     * Set sets the mapping pattern for all dependencies included
     * in this
     *             assembly. Default is
     * ${artifact.artifactId}-${artifact.version}${dashClassifier?}.${artifact.extension}.
     *             (Since 2.2-beta-2; 2.2-beta-1 uses
     * ${artifactId}-${version}${dashClassifier?}.${extension}).
     *             NOTE: If the dependencySet specifies unpack ==
     * true, outputFileNameMapping WILL NOT BE USED; in these
     * cases,
     *             use outputDirectory.
     *             See the plugin FAQ for more details about
     * entries usable in the outputFileNameMapping parameter.
     * 
     * @param outputFileNameMapping a outputFileNameMapping object.
     */
    public void setOutputFileNameMapping( String outputFileNameMapping )
    {
        this.outputFileNameMapping = outputFileNameMapping;
    } //-- void setOutputFileNameMapping( String )

    /**
     * Set sets the dependency scope for this dependencySet.
     *             Default scope value is "runtime".
     * 
     * @param scope a scope object.
     */
    public void setScope( String scope )
    {
        this.scope = scope;
    } //-- void setScope( String )

    /**
     * Set if set to true, this property will unpack all
     * dependencies
     *             into the specified output directory. When set to
     * false,
     *             dependencies will be included as archives
     * (jars). Can only unpack
     *             jar, zip, tar.gz, and tar.bz archives. Default
     * value is false.
     * 
     * @param unpack a unpack object.
     */
    public void setUnpack( boolean unpack )
    {
        this.unpack = unpack;
    } //-- void setUnpack( boolean )

    /**
     * Set allows the specification of includes and excludes, along
     * with filtering options, for items
     *           unpacked from a dependency artifact. (Since 2.2).
     * 
     * @param unpackOptions a unpackOptions object.
     */
    public void setUnpackOptions( UnpackOptions unpackOptions )
    {
        this.unpackOptions = unpackOptions;
    } //-- void setUnpackOptions( UnpackOptions )

    /**
     * Set determines whether the artifact produced during the
     * current project's
     *           build should be included in this dependency set.
     * Default value is true,
     *           for backward compatibility. (Since 2.2).
     * 
     * @param useProjectArtifact a useProjectArtifact object.
     */
    public void setUseProjectArtifact( boolean useProjectArtifact )
    {
        this.useProjectArtifact = useProjectArtifact;
    } //-- void setUseProjectArtifact( boolean )

    /**
     * Set determines whether the attached artifacts produced
     * during the current project's
     *           build should be included in this dependency set.
     * Default value is false. (Since 2.2).
     * 
     * @param useProjectAttachments a useProjectAttachments object.
     */
    public void setUseProjectAttachments( boolean useProjectAttachments )
    {
        this.useProjectAttachments = useProjectAttachments;
    } //-- void setUseProjectAttachments( boolean )

    /**
     * Set when specified as true, any include/exclude patterns
     * which aren't used to filter an actual
     *           artifact during assembly creation will cause the
     * build to fail with an error. This is meant
     *           to highlight obsolete inclusions or exclusions, or
     * else signal that the assembly descriptor
     *           is incorrectly configured. (Since 2.2).
     * 
     * @param useStrictFiltering a useStrictFiltering object.
     */
    public void setUseStrictFiltering( boolean useStrictFiltering )
    {
        this.useStrictFiltering = useStrictFiltering;
    } //-- void setUseStrictFiltering( boolean )

    /**
     * Set determines whether transitive dependencies will be
     * included in the processing of
     *           the current dependency set. If true,
     * includes/excludes/useTransitiveFiltering
     *           will apply to transitive dependency artifacts in
     * addition to the main project
     *           dependency artifacts. If false,
     * useTransitiveFiltering is meaningless, and
     *           includes/excludes only affect the immediate
     * dependencies of the project.
     *           By default, this value is true. (Since 2.2).
     * 
     * @param useTransitiveDependencies a useTransitiveDependencies
     * object.
     */
    public void setUseTransitiveDependencies( boolean useTransitiveDependencies )
    {
        this.useTransitiveDependencies = useTransitiveDependencies;
    } //-- void setUseTransitiveDependencies( boolean )

    /**
     * Set determines whether the include/exclude patterns in this
     * dependency set will be applied to
     *           the transitive path of a given artifact. If true,
     * and the current artifact is a transitive
     *           dependency brought in by another artifact which
     * matches an inclusion or exclusion pattern,
     *           then the current artifact has the same
     * inclusion/exclusion logic applied to it as well. By
     *           default, this value is false, in order to preserve
     * backward compatibility with version 2.1.
     *           This means that includes/excludes only apply
     * directly to the current artifact, and not to
     *           the transitive set of artifacts which brought it
     * in. (Since 2.2).
     * 
     * @param useTransitiveFiltering a useTransitiveFiltering object
     */
    public void setUseTransitiveFiltering( boolean useTransitiveFiltering )
    {
        this.useTransitiveFiltering = useTransitiveFiltering;
    } //-- void setUseTransitiveFiltering( boolean )

}
