/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.5.1,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.plugins.assembly.model;

/**
 * 
 *         A fileSet allows the inclusion of groups of files into
 * the assembly.
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class FileSet
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             Whether standard exclusion patterns, such as
     * those matching CVS and Subversion
     *             metadata files, should be used when calculating
     * the files affected by this set.
     *             For backward compatibility, the default value is
     * true. (Since 2.2)
     *           .
     */
    private boolean useDefaultExcludes = true;

    /**
     * 
     *             Sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     *           
     */
    private String outputDirectory;

    /**
     * Field includes.
     */
    private java.util.List<String> includes;

    /**
     * Field excludes.
     */
    private java.util.List<String> excludes;

    /**
     * 
     *             
     *             Similar to a UNIX permission, sets the file mode
     * of the files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only.  The default value is 0644.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *             
     *           
     */
    private String fileMode;

    /**
     * 
     *             
     *             Similar to a UNIX permission, sets the directory
     * mode of the directories
     *             included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only. The default value is 0755.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     *             
     *           
     */
    private String directoryMode;

    /**
     * 
     *             Sets the absolute or relative location from the
     * module's
     *             directory. For example, "src/main/bin" would
     * select this
     *             subdirectory of the project in which this
     * dependency is defined.
     *           
     */
    private String directory;

    /**
     * 
     *             
     *             Sets the line-endings of the files in this
     * fileSet.
     *             Valid values:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     *             
     *           
     */
    private String lineEnding;

    /**
     * 
     *           Whether to filter symbols in the files as they are
     * copied, using
     *           properties from the build configuration. (Since
     * 2.2)
     *           .
     */
    private boolean filtered = false;

    /**
     * Field nonFilteredFileExtensions.
     */
    private java.util.List<String> nonFilteredFileExtensions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude.
     * 
     * @param string a string object.
     */
    public void addExclude( String string )
    {
        getExcludes().add( string );
    } //-- void addExclude( String )

    /**
     * Method addInclude.
     * 
     * @param string a string object.
     */
    public void addInclude( String string )
    {
        getIncludes().add( string );
    } //-- void addInclude( String )

    /**
     * Method addNonFilteredFileExtension.
     * 
     * @param string a string object.
     */
    public void addNonFilteredFileExtension( String string )
    {
        getNonFilteredFileExtensions().add( string );
    } //-- void addNonFilteredFileExtension( String )

    /**
     * Get sets the absolute or relative location from the module's
     *             directory. For example, "src/main/bin" would
     * select this
     *             subdirectory of the project in which this
     * dependency is defined.
     * 
     * @return String
     */
    public String getDirectory()
    {
        return this.directory;
    } //-- String getDirectory()

    /**
     * Get similar to a UNIX permission, sets the directory mode of
     * the directories
     *             included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only. The default value is 0755.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @return String
     */
    public String getDirectoryMode()
    {
        return this.directoryMode;
    } //-- String getDirectoryMode()

    /**
     * Method getExcludes.
     * 
     * @return List
     */
    public java.util.List<String> getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList<String>();
        }

        return this.excludes;
    } //-- java.util.List<String> getExcludes()

    /**
     * Get similar to a UNIX permission, sets the file mode of the
     * files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only.  The default value is 0644.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @return String
     */
    public String getFileMode()
    {
        return this.fileMode;
    } //-- String getFileMode()

    /**
     * Method getIncludes.
     * 
     * @return List
     */
    public java.util.List<String> getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList<String>();
        }

        return this.includes;
    } //-- java.util.List<String> getIncludes()

    /**
     * Get sets the line-endings of the files in this fileSet.
     *             Valid values:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     * 
     * @return String
     */
    public String getLineEnding()
    {
        return this.lineEnding;
    } //-- String getLineEnding()

    /**
     * Method getNonFilteredFileExtensions.
     * 
     * @return List
     */
    public java.util.List<String> getNonFilteredFileExtensions()
    {
        if ( this.nonFilteredFileExtensions == null )
        {
            this.nonFilteredFileExtensions = new java.util.ArrayList<String>();
        }

        return this.nonFilteredFileExtensions;
    } //-- java.util.List<String> getNonFilteredFileExtensions()

    /**
     * Get sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     * 
     * @return String
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    } //-- String getOutputDirectory()

    /**
     * Get whether to filter symbols in the files as they are
     * copied, using
     *           properties from the build configuration. (Since
     * 2.2).
     * 
     * @return boolean
     */
    public boolean isFiltered()
    {
        return this.filtered;
    } //-- boolean isFiltered()

    /**
     * Get whether standard exclusion patterns, such as those
     * matching CVS and Subversion
     *             metadata files, should be used when calculating
     * the files affected by this set.
     *             For backward compatibility, the default value is
     * true. (Since 2.2).
     * 
     * @return boolean
     */
    public boolean isUseDefaultExcludes()
    {
        return this.useDefaultExcludes;
    } //-- boolean isUseDefaultExcludes()

    /**
     * Method removeExclude.
     * 
     * @param string a string object.
     */
    public void removeExclude( String string )
    {
        getExcludes().remove( string );
    } //-- void removeExclude( String )

    /**
     * Method removeInclude.
     * 
     * @param string a string object.
     */
    public void removeInclude( String string )
    {
        getIncludes().remove( string );
    } //-- void removeInclude( String )

    /**
     * Method removeNonFilteredFileExtension.
     * 
     * @param string a string object.
     */
    public void removeNonFilteredFileExtension( String string )
    {
        getNonFilteredFileExtensions().remove( string );
    } //-- void removeNonFilteredFileExtension( String )

    /**
     * Set sets the absolute or relative location from the module's
     *             directory. For example, "src/main/bin" would
     * select this
     *             subdirectory of the project in which this
     * dependency is defined.
     * 
     * @param directory a directory object.
     */
    public void setDirectory( String directory )
    {
        this.directory = directory;
    } //-- void setDirectory( String )

    /**
     * Set similar to a UNIX permission, sets the directory mode of
     * the directories
     *             included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of
     *             Read = 4, Write = 2, and Execute = 1.  For
     * example, the value
     *             0755 translates to User read-write, Group and
     * Other read-only. The default value is 0755.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @param directoryMode a directoryMode object.
     */
    public void setDirectoryMode( String directoryMode )
    {
        this.directoryMode = directoryMode;
    } //-- void setDirectoryMode( String )

    /**
     * Set when &lt;exclude&gt; subelements are present, they
     * define a set of
     *             files and directory to exclude. If none is
     * present, then
     *             &lt;excludes&gt; represents no exclusions.
     * 
     * @param excludes a excludes object.
     */
    public void setExcludes( java.util.List<String> excludes )
    {
        this.excludes = excludes;
    } //-- void setExcludes( java.util.List )

    /**
     * Set similar to a UNIX permission, sets the file mode of the
     * files included.
     *             THIS IS AN OCTAL VALUE.
     *             Format: (User)(Group)(Other) where each
     * component is a sum of Read = 4,
     *             Write = 2, and Execute = 1.  For example, the
     * value 0644
     *             translates to User read-write, Group and Other
     * read-only.  The default value is 0644.
     *             <a
     * href="http://www.onlamp.com/pub/a/bsd/2000/09/06/FreeBSD_Basics.html">(more
     * on unix-style permissions)</a>
     * 
     * @param fileMode a fileMode object.
     */
    public void setFileMode( String fileMode )
    {
        this.fileMode = fileMode;
    } //-- void setFileMode( String )

    /**
     * Set whether to filter symbols in the files as they are
     * copied, using
     *           properties from the build configuration. (Since
     * 2.2).
     * 
     * @param filtered a filtered object.
     */
    public void setFiltered( boolean filtered )
    {
        this.filtered = filtered;
    } //-- void setFiltered( boolean )

    /**
     * Set when &lt;include&gt; subelements are present, they
     * define a set of
     *             files and directory to include. If none is
     * present, then
     *             &lt;includes&gt; represents all valid values.
     * 
     * @param includes a includes object.
     */
    public void setIncludes( java.util.List<String> includes )
    {
        this.includes = includes;
    } //-- void setIncludes( java.util.List )

    /**
     * Set sets the line-endings of the files in this fileSet.
     *             Valid values:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     * 
     * @param lineEnding a lineEnding object.
     */
    public void setLineEnding( String lineEnding )
    {
        this.lineEnding = lineEnding;
    } //-- void setLineEnding( String )

    /**
     * Set additional file extensions to not apply filtering (Since
     * 3.2.0).
     * 
     * @param nonFilteredFileExtensions a nonFilteredFileExtensions
     * object.
     */
    public void setNonFilteredFileExtensions( java.util.List<String> nonFilteredFileExtensions )
    {
        this.nonFilteredFileExtensions = nonFilteredFileExtensions;
    } //-- void setNonFilteredFileExtensions( java.util.List )

    /**
     * Set sets the output directory relative to the root
     *             of the root directory of the assembly. For
     * example,
     *             "log" will put the specified files in the log
     * directory.
     * 
     * @param outputDirectory a outputDirectory object.
     */
    public void setOutputDirectory( String outputDirectory )
    {
        this.outputDirectory = outputDirectory;
    } //-- void setOutputDirectory( String )

    /**
     * Set whether standard exclusion patterns, such as those
     * matching CVS and Subversion
     *             metadata files, should be used when calculating
     * the files affected by this set.
     *             For backward compatibility, the default value is
     * true. (Since 2.2).
     * 
     * @param useDefaultExcludes a useDefaultExcludes object.
     */
    public void setUseDefaultExcludes( boolean useDefaultExcludes )
    {
        this.useDefaultExcludes = useDefaultExcludes;
    } //-- void setUseDefaultExcludes( boolean )

}
