/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.changes.AbstractChangesReport;
import org.apache.maven.plugin.changes.ChangesReportGenerator;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.maven.plugin.changes.FeedGenerator;
import org.apache.maven.plugin.changes.ReleaseUtils;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="changes-report", threadSafe=true)
public class ChangesMojo
extends AbstractChangesReport {
    @Parameter(defaultValue="false")
    private boolean aggregated;
    @Parameter(property="changes.addActionDate", defaultValue="false")
    private boolean addActionDate;
    @Parameter(defaultValue="true")
    private boolean escapeHTML;
    @Parameter(defaultValue="${project.build.directory}/changes", required=true, readonly=true)
    private File filteredOutputDirectory;
    @Parameter(defaultValue="false")
    private boolean filteringChanges;
    @Parameter(property="changes.issueLinkTemplate", defaultValue="%URL%/ViewIssue.jspa?key=%ISSUE%")
    private String issueLinkTemplate;
    @Parameter
    private Map issueLinkTemplatePerSystem;
    @Component
    private MavenFileFilter mavenFileFilter;
    @Parameter(defaultValue="yyyy-MM-dd")
    private String publishDateFormat;
    @Parameter(defaultValue="en")
    private String publishDateLocale;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.issueManagement.system}", readonly=true)
    private String system;
    @Parameter(defaultValue="team-list.html")
    private String teamlist;
    @Parameter(defaultValue="${project.issueManagement.url}", readonly=true)
    private String url;
    @Parameter
    private String feedType;
    @Parameter(property="changes.xmlPath", defaultValue="src/changes/changes.xml")
    private File xmlPath;
    private ReleaseUtils releaseUtils = new ReleaseUtils(this.getLog());
    private CaseInsensitiveMap caseInsensitiveIssueLinkTemplatePerSystem;

    public boolean canGenerateReport() {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the Changes Report in this project because it's not the Execution Root");
            return false;
        }
        return this.xmlPath.isFile();
    }

    public void executeReport(Locale locale) throws MavenReportException {
        Date now = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.publishDateFormat, new Locale(this.publishDateLocale));
        Properties additionalProperties = new Properties();
        additionalProperties.put("publishDate", simpleDateFormat.format(now));
        ChangesXML changesXml = this.getChangesFromFile(this.xmlPath, this.project, additionalProperties);
        if (changesXml == null) {
            return;
        }
        if (this.aggregated) {
            String basePath = this.project.getBasedir().getAbsolutePath();
            String absolutePath = this.xmlPath.getAbsolutePath();
            if (!absolutePath.startsWith(basePath)) {
                this.getLog().warn((CharSequence)"xmlPath should be within the project dir for aggregated changes report.");
                return;
            }
            String relativePath = absolutePath.substring(basePath.length());
            List releaseList = changesXml.getReleaseList();
            for (Object o : this.project.getCollectedProjects()) {
                MavenProject childProject = (MavenProject)o;
                File changesFile = new File(childProject.getBasedir(), relativePath);
                ChangesXML childXml = this.getChangesFromFile(changesFile, childProject, additionalProperties);
                if (childXml == null) continue;
                releaseList = this.releaseUtils.mergeReleases(releaseList, childProject.getName(), childXml.getReleaseList());
            }
            changesXml.setReleaseList(releaseList);
        }
        ChangesReportGenerator report = new ChangesReportGenerator(changesXml.getReleaseList());
        report.setAuthor(changesXml.getAuthor());
        report.setTitle(changesXml.getTitle());
        report.setEscapeHTML(this.escapeHTML);
        this.caseInsensitiveIssueLinkTemplatePerSystem = this.issueLinkTemplatePerSystem == null ? new CaseInsensitiveMap() : new CaseInsensitiveMap(this.issueLinkTemplatePerSystem);
        this.addIssueLinkTemplate("default", this.issueLinkTemplate);
        this.addIssueLinkTemplate("Bitbucket", "%URL%/issue/%ISSUE%");
        this.addIssueLinkTemplate("Bugzilla", "%URL%/show_bug.cgi?id=%ISSUE%");
        this.addIssueLinkTemplate("GitHub", "%URL%/%ISSUE%");
        this.addIssueLinkTemplate("GoogleCode", "%URL%/detail?id=%ISSUE%");
        this.addIssueLinkTemplate("JIRA", "%URL%/%ISSUE%");
        this.addIssueLinkTemplate("Mantis", "%URL%/view.php?id=%ISSUE%");
        this.addIssueLinkTemplate("MKS", "%URL%/viewissue?selection=%ISSUE%");
        this.addIssueLinkTemplate("Redmine", "%URL%/issues/show/%ISSUE%");
        this.addIssueLinkTemplate("Scarab", "%URL%/issues/id/%ISSUE%");
        this.addIssueLinkTemplate("SourceForge", "http://sourceforge.net/support/tracker.php?aid=%ISSUE%");
        this.addIssueLinkTemplate("SourceForge2", "%URL%/%ISSUE%");
        this.addIssueLinkTemplate("Trac", "%URL%/ticket/%ISSUE%");
        this.addIssueLinkTemplate("Trackplus", "%URL%/printItem.action?key=%ISSUE%");
        this.addIssueLinkTemplate("YouTrack", "%URL%/issue/%ISSUE%");
        this.logIssueLinkTemplatePerSystem((Map)this.caseInsensitiveIssueLinkTemplatePerSystem);
        report.setIssueLinksPerSystem((Map)this.caseInsensitiveIssueLinkTemplatePerSystem);
        report.setSystem(this.system);
        report.setTeamlist(this.teamlist);
        report.setUrl(this.url);
        report.setAddActionDate(this.addActionDate);
        if (StringUtils.isEmpty((String)this.url)) {
            this.getLog().warn((CharSequence)"No issue management URL defined in POM. Links to your issues will not work correctly.");
        }
        boolean feedGenerated = false;
        if (StringUtils.isNotEmpty((String)this.feedType)) {
            feedGenerated = this.generateFeed(changesXml, locale);
        }
        report.setLinkToFeed(feedGenerated);
        report.doGenerateReport(this.getBundle(locale), this.getSink());
        this.copyStaticResources();
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.issues.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.issues.name");
    }

    public String getOutputName() {
        return "changes-report";
    }

    private ChangesXML getChangesFromFile(File changesXml, MavenProject project, Properties additionalProperties) throws MavenReportException {
        if (!changesXml.exists()) {
            this.getLog().warn((CharSequence)("changes.xml file " + changesXml.getAbsolutePath() + " does not exist."));
            return null;
        }
        if (this.filteringChanges) {
            if (!this.filteredOutputDirectory.exists()) {
                this.filteredOutputDirectory.mkdirs();
            }
            XmlStreamReader xmlStreamReader = null;
            try {
                xmlStreamReader = new XmlStreamReader(changesXml);
                String encoding = xmlStreamReader.getEncoding();
                File resultFile = new File(this.filteredOutputDirectory, project.getGroupId() + "." + project.getArtifactId() + "-changes.xml");
                MavenFileFilterRequest mavenFileFilterRequest = new MavenFileFilterRequest(changesXml, resultFile, true, project, Collections.EMPTY_LIST, false, encoding, this.session, additionalProperties);
                this.mavenFileFilter.copyFile(mavenFileFilterRequest);
                changesXml = resultFile;
            }
            catch (IOException e) {
                throw new MavenReportException("Exception during filtering changes file : " + e.getMessage(), (Exception)e);
            }
            catch (MavenFilteringException e) {
                throw new MavenReportException("Exception during filtering changes file : " + e.getMessage(), (Exception)((Object)e));
            }
            finally {
                if (xmlStreamReader != null) {
                    IOUtil.close((Reader)xmlStreamReader);
                }
            }
        }
        return new ChangesXML(changesXml, this.getLog());
    }

    private void addIssueLinkTemplate(String system, String issueLinkTemplate) {
        if (this.caseInsensitiveIssueLinkTemplatePerSystem == null) {
            this.caseInsensitiveIssueLinkTemplatePerSystem = new CaseInsensitiveMap();
        }
        if (!this.caseInsensitiveIssueLinkTemplatePerSystem.containsKey((Object)system)) {
            this.caseInsensitiveIssueLinkTemplatePerSystem.put((Object)system, (Object)issueLinkTemplate);
        }
    }

    private void copyStaticResources() throws MavenReportException {
        String pluginResourcesBase = "org/apache/maven/plugin/changes";
        String[] resourceNames = new String[]{"images/add.gif", "images/fix.gif", "images/icon_help_sml.gif", "images/remove.gif", "images/rss.png", "images/update.gif"};
        try {
            this.getLog().debug((CharSequence)"Copying static resources.");
            for (String resourceName : resourceNames) {
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/maven/plugin/changes/" + resourceName);
                FileUtils.copyURLToFile((URL)url, (File)new File(this.getReportOutputDirectory(), resourceName));
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy static resources.");
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("changes-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected String getTeamlist() {
        return this.teamlist;
    }

    private void logIssueLinkTemplatePerSystem(Map issueLinkTemplatePerSystem) {
        if (this.getLog().isDebugEnabled()) {
            if (issueLinkTemplatePerSystem == null) {
                this.getLog().debug((CharSequence)"No issueLinkTemplatePerSystem configuration was found");
            } else {
                Iterator i$ = issueLinkTemplatePerSystem.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    this.getLog().debug((CharSequence)("issueLinkTemplatePerSystem[" + entry.getKey() + "] = " + entry.getValue()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateFeed(ChangesXML changesXml, Locale locale) {
        this.getLog().debug((CharSequence)("Generating " + this.feedType + " feed."));
        boolean success = true;
        FeedGenerator feed = new FeedGenerator(locale);
        feed.setLink(this.project.getUrl() + "/changes-report.html");
        feed.setTitle(this.project.getName() + ": " + changesXml.getTitle());
        feed.setAuthor(changesXml.getAuthor());
        feed.setDateFormat(new SimpleDateFormat(this.publishDateFormat, new Locale(this.publishDateLocale)));
        Writer writer = null;
        try {
            writer = new FileWriter(new File(this.getReportOutputDirectory(), "changes.rss"));
            feed.export(changesXml.getReleaseList(), this.feedType, writer);
        }
        catch (IOException ex) {
            success = false;
            this.getLog().warn((CharSequence)("Failed to create rss feed: " + ex.getMessage()));
            this.getLog().debug((Throwable)ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                this.getLog().warn((CharSequence)("Failed to close writer: " + ex.getMessage()));
                this.getLog().debug((Throwable)ex);
            }
        }
        return success;
    }
}

