/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.clean;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class CleanMojo
extends AbstractMojo {
    private static final int DELETE_RETRY_SLEEP_MILLIS = 10;
    private File directory;
    private File outputDirectory;
    private File testOutputDirectory;

    public void execute() throws MojoExecutionException {
        this.removeDirectory(this.directory);
        this.removeDirectory(this.outputDirectory);
        this.removeDirectory(this.testOutputDirectory);
    }

    private void removeDirectory(File dir) throws MojoExecutionException {
        if (dir != null && dir.exists() && dir.isDirectory()) {
            this.getLog().info((CharSequence)("Deleting directory " + dir.getAbsolutePath()));
            this.removeDir(dir);
        }
    }

    private boolean delete(File f) {
        if (!f.delete()) {
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
                return f.delete();
            }
            catch (InterruptedException ex) {
                return f.delete();
            }
        }
        return true;
    }

    protected void removeDir(File d) throws MojoExecutionException {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                this.removeDir(f);
                continue;
            }
            if (this.delete(f)) continue;
            String message = "Unable to delete file " + f.getAbsolutePath();
            throw new MojoExecutionException(message);
        }
        if (!this.delete(d)) {
            String message = "Unable to delete directory " + d.getAbsolutePath();
            throw new MojoExecutionException(message);
        }
    }
}

