/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class DependencyStatusSets {
    Set<Artifact> resolvedDependencies = null;
    Set<Artifact> unResolvedDependencies = null;
    Set<Artifact> skippedDependencies = null;

    public DependencyStatusSets() {
    }

    public DependencyStatusSets(Set<Artifact> resolved, Set<Artifact> unResolved, Set<Artifact> skipped) {
        if (resolved != null) {
            this.resolvedDependencies = new LinkedHashSet<Artifact>(resolved);
        }
        if (unResolved != null) {
            this.unResolvedDependencies = new LinkedHashSet<Artifact>(unResolved);
        }
        if (skipped != null) {
            this.skippedDependencies = new LinkedHashSet<Artifact>(skipped);
        }
    }

    public Set<Artifact> getResolvedDependencies() {
        return this.resolvedDependencies;
    }

    public void setResolvedDependencies(Set<Artifact> resolvedDependencies) {
        this.resolvedDependencies = resolvedDependencies != null ? new LinkedHashSet<Artifact>(resolvedDependencies) : null;
    }

    public Set<Artifact> getSkippedDependencies() {
        return this.skippedDependencies;
    }

    public void setSkippedDependencies(Set<Artifact> skippedDependencies) {
        this.skippedDependencies = skippedDependencies != null ? new LinkedHashSet<Artifact>(skippedDependencies) : null;
    }

    public Set<Artifact> getUnResolvedDependencies() {
        return this.unResolvedDependencies;
    }

    public void setUnResolvedDependencies(Set<Artifact> unResolvedDependencies) {
        this.unResolvedDependencies = unResolvedDependencies != null ? new LinkedHashSet<Artifact>(unResolvedDependencies) : null;
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename) {
        return this.getOutput(outputAbsoluteArtifactFilename, true);
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename, boolean outputScope) {
        return this.getOutput(outputAbsoluteArtifactFilename, outputScope, false);
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename, boolean outputScope, boolean sort) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("The following files have been resolved:\n");
        if (this.resolvedDependencies == null || this.resolvedDependencies.isEmpty()) {
            sb.append("   none\n");
        } else {
            sb.append((CharSequence)this.buildArtifactListOutput(this.resolvedDependencies, outputAbsoluteArtifactFilename, outputScope, sort));
        }
        if (this.skippedDependencies != null && !this.skippedDependencies.isEmpty()) {
            sb.append("\n");
            sb.append("The following files were skipped:\n");
            LinkedHashSet<Artifact> skippedDependencies = new LinkedHashSet<Artifact>();
            skippedDependencies.addAll(this.skippedDependencies);
            sb.append((CharSequence)this.buildArtifactListOutput(skippedDependencies, outputAbsoluteArtifactFilename, outputScope, sort));
        }
        if (this.unResolvedDependencies != null && !this.unResolvedDependencies.isEmpty()) {
            sb.append("\n");
            sb.append("The following files have NOT been resolved:\n");
            LinkedHashSet<Artifact> unResolvedDependencies = new LinkedHashSet<Artifact>();
            unResolvedDependencies.addAll(this.unResolvedDependencies);
            sb.append((CharSequence)this.buildArtifactListOutput(unResolvedDependencies, outputAbsoluteArtifactFilename, outputScope, sort));
        }
        sb.append("\n");
        return sb.toString();
    }

    private StringBuilder buildArtifactListOutput(Set<Artifact> artifacts, boolean outputAbsoluteArtifactFilename, boolean outputScope, boolean sort) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> artifactStringList = new ArrayList<String>();
        for (Artifact artifact : artifacts) {
            String artifactFilename = null;
            if (outputAbsoluteArtifactFilename) {
                try {
                    artifactFilename = artifact.getFile().getAbsoluteFile().getPath();
                }
                catch (NullPointerException e) {
                    artifactFilename = null;
                }
            }
            String id = outputScope ? artifact.toString() : artifact.getId();
            artifactStringList.add("   " + id + (outputAbsoluteArtifactFilename ? ":" + artifactFilename : "") + "\n");
        }
        if (sort) {
            Collections.sort(artifactStringList);
        }
        for (String artifactString : artifactStringList) {
            sb.append(artifactString);
        }
        return sb;
    }
}

