/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils.resolvers;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.utils.resolvers.ArtifactsResolver;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;

public class DefaultArtifactsResolver
implements ArtifactsResolver {
    private ArtifactResolver resolver;
    private ProjectBuildingRequest buildingRequest;
    boolean stopOnFailure;

    public DefaultArtifactsResolver(ArtifactResolver theResolver, ProjectBuildingRequest buildingRequest, boolean theStopOnFailure) {
        this.resolver = theResolver;
        this.buildingRequest = buildingRequest;
        this.stopOnFailure = theStopOnFailure;
    }

    @Override
    public Set<Artifact> resolve(Set<Artifact> artifacts, Log log) throws MojoExecutionException {
        HashSet<Artifact> resolvedArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            try {
                artifact = this.resolver.resolveArtifact(this.buildingRequest, artifact);
                resolvedArtifacts.add(artifact);
            }
            catch (ArtifactResolverException ex) {
                log.debug((CharSequence)("error resolving: " + artifact.getId()));
                log.debug((Throwable)ex);
                if (!this.stopOnFailure) continue;
                throw new MojoExecutionException("error resolving: " + artifact.getId(), (Exception)((Object)ex));
            }
        }
        return resolvedArtifacts;
    }
}

