/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils.translators;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.dependency.utils.translators.ArtifactTranslator;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.repository.RepositoryManager;
import org.codehaus.plexus.util.StringUtils;

public class ClassifierTypeTranslator
implements ArtifactTranslator {
    private String classifier;
    private String type;
    private ArtifactFactory factory;
    private RepositoryManager repositoryManager;
    ProjectBuildingRequest buildingRequest;

    public ClassifierTypeTranslator(String theClassifier, String theType, ArtifactFactory theFactory, RepositoryManager theRepository, ProjectBuildingRequest buildingRequest) {
        this.classifier = theClassifier;
        this.type = theType;
        this.factory = theFactory;
        this.repositoryManager = theRepository;
        this.buildingRequest = buildingRequest;
    }

    @Override
    public Set<Artifact> translate(Set<Artifact> artifacts, Log log) {
        log.debug((CharSequence)("Translating Artifacts using Classifier: " + this.classifier + " and Type: " + this.type));
        HashSet<Artifact> results = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            String useType = StringUtils.isNotEmpty((String)this.type) ? this.type : artifact.getType();
            String useClassifier = StringUtils.isNotEmpty((String)this.classifier) ? this.classifier : artifact.getClassifier();
            Artifact newArtifact = this.factory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), useType, useClassifier);
            newArtifact.setScope(artifact.getScope());
            if ("system".equals(newArtifact.getScope())) {
                File baseDir = this.repositoryManager.getLocalRepositoryBasedir(this.buildingRequest);
                String path = this.repositoryManager.getPathForLocalArtifact(this.buildingRequest, newArtifact);
                newArtifact.setFile(new File(baseDir, path));
            }
            results.add(newArtifact);
        }
        return results;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String theType) {
        this.type = theType;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String theClassifier) {
        this.classifier = theClassifier;
    }
}

