/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.deploy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.deploy.AbstractDeployMojo;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DeployFileMojo
extends AbstractDeployMojo {
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging;
    private File file;
    private String repositoryId;
    private String url;
    private ArtifactFactory artifactFactory;
    private ArtifactRepositoryLayout layout;
    private ArtifactRepositoryFactory repositoryFactory;
    private File pomFile;
    private boolean generatePom = true;

    public void execute() throws MojoExecutionException {
        try {
            if (this.pomFile != null) {
                if (!this.pomFile.exists()) {
                    throw new MojoExecutionException("Specified pomFile does not exist");
                }
                this.processPom();
            }
            if (this.groupId == null || this.artifactId == null || this.version == null || this.packaging == null) {
                throw new MojoExecutionException("Missing group, artifact, version, or packaging information");
            }
            Artifact artifact = this.artifactFactory.createArtifact(this.groupId, this.artifactId, this.version, null, this.packaging);
            ArtifactRepository deploymentRepository = this.repositoryFactory.createDeploymentArtifactRepository(this.repositoryId, this.url, this.layout, false);
            if (this.generatePom) {
                if (null == this.pomFile) {
                    this.generatePomFile();
                }
                ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, this.pomFile);
                artifact.addMetadata((ArtifactMetadata)metadata);
            }
            if (!this.file.exists()) {
                throw new MojoExecutionException(this.file.getPath() + " not found.");
            }
            this.getDeployer().deploy(this.file, artifact, deploymentRepository, this.getLocalRepository());
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPom() throws MojoExecutionException {
        if (this.pomFile == null) return;
        if (!this.pomFile.exists()) return;
        FileReader reader = null;
        try {
            reader = new FileReader(this.pomFile);
            MavenXpp3Reader modelReader = new MavenXpp3Reader();
            Model model = modelReader.read((Reader)reader);
            Parent parent = model.getParent();
            if (parent != null && parent.getGroupId() != null) {
                this.groupId = parent.getGroupId();
            } else if (model.getGroupId() != null) {
                this.groupId = model.getGroupId();
            }
            if (model.getArtifactId() != null) {
                this.artifactId = model.getArtifactId();
            }
            if (model.getVersion() != null) {
                this.version = model.getVersion();
            }
            if (model.getPackaging() != null) {
                this.packaging = model.getPackaging();
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("Error reading specified POM file: " + e.getMessage(), (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Error reading specified POM file: " + e2.getMessage(), (Exception)e2);
                }
                catch (XmlPullParserException e3) {
                    throw new MojoExecutionException("Error reading specified POM file: " + e3.getMessage(), (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
    }

    private void generatePomFile() throws MojoExecutionException {
        FileWriter fw = null;
        try {
            File tempFile = File.createTempFile("mvninstall", ".pom");
            tempFile.deleteOnExit();
            Model model = new Model();
            model.setModelVersion("4.0.0");
            model.setGroupId(this.groupId);
            model.setArtifactId(this.artifactId);
            model.setVersion(this.version);
            model.setPackaging(this.packaging);
            model.setDescription("POM was created from deploy:deploy-file");
            fw = new FileWriter(tempFile);
            new MavenXpp3Writer().write((Writer)fw, model);
            this.pomFile = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
    }
}

