/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.deploy;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.deploy.AbstractDeployMojo;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;

public class DeployMojo
extends AbstractDeployMojo {
    private Artifact artifact;
    private String packaging;
    private File pomFile;
    private ArtifactRepository deploymentRepository;
    private List attachedArtifacts;
    private boolean updateReleaseInfo;

    public void execute() throws MojoExecutionException {
        boolean isPomArtifact;
        File sshFile;
        if (this.deploymentRepository == null) {
            String msg = "Deployment failed: repository element was not specified in the pom inside distributionManagement element";
            throw new MojoExecutionException(msg);
        }
        String protocol = this.deploymentRepository.getProtocol();
        if (protocol.equals("scp") && !(sshFile = new File(System.getProperty("user.home"), ".ssh")).exists()) {
            sshFile.mkdirs();
        }
        if (!(isPomArtifact = "pom".equals(this.packaging))) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(this.artifact, this.pomFile);
            this.artifact.addMetadata((ArtifactMetadata)metadata);
        }
        if (this.updateReleaseInfo) {
            this.artifact.setRelease(true);
        }
        try {
            if (isPomArtifact) {
                this.getDeployer().deploy(this.pomFile, this.artifact, this.deploymentRepository, this.getLocalRepository());
            } else {
                File file = this.artifact.getFile();
                if (file == null) {
                    throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
                }
                this.getDeployer().deploy(file, this.artifact, this.deploymentRepository, this.getLocalRepository());
            }
            Iterator i = this.attachedArtifacts.iterator();
            while (i.hasNext()) {
                Artifact attached = (Artifact)i.next();
                this.getDeployer().deploy(attached.getFile(), attached, this.deploymentRepository, this.getLocalRepository());
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

