/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.AbstractEarMojo;
import org.apache.maven.plugin.ear.ApplicationXmlWriter;
import org.apache.maven.plugin.ear.EarPluginException;
import org.codehaus.plexus.util.FileUtils;

public class GenerateApplicationXmlMojo
extends AbstractEarMojo {
    public static final String VERSION_1_3 = "1.3";
    public static final String VERSION_1_4 = "1.4";
    public static final String UTF_8 = "UTF-8";
    private Boolean generateApplicationXml = Boolean.TRUE;
    private String version = "1.3";
    private String displayName = null;
    private String description = null;
    private String encoding = "UTF-8";
    private String generatedDescriptorLocation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.getLog().debug((CharSequence)" ======= GenerateApplicationXmlMojo settings =======");
        this.getLog().debug((CharSequence)("generateApplicationXml[" + this.generateApplicationXml + "]"));
        this.getLog().debug((CharSequence)("version[" + this.version + "]"));
        this.getLog().debug((CharSequence)("displayName[" + this.displayName + "]"));
        this.getLog().debug((CharSequence)("description[" + this.description + "]"));
        this.getLog().debug((CharSequence)("encoding[" + this.encoding + "]"));
        this.getLog().debug((CharSequence)("generatedDescriptorLocation[" + this.generatedDescriptorLocation + "]"));
        if (!this.generateApplicationXml.booleanValue()) {
            this.getLog().debug((CharSequence)"Generation of application.xml is disabled");
            return;
        }
        if (!this.version.equals(VERSION_1_3) && !this.version.equals(VERSION_1_4)) {
            throw new MojoExecutionException("Invalid version[" + this.version + "]");
        }
        this.getLog().info((CharSequence)"Generating application.xml");
        try {
            this.generateDeploymentDescriptor();
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to generate application.xml", (Exception)e);
        }
        try {
            FileUtils.copyFileToDirectory((File)new File(this.generatedDescriptorLocation, "application.xml"), (File)new File(this.getWorkDirectory(), "META-INF"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy application.xml to final destination", (Exception)e);
        }
    }

    protected void generateDeploymentDescriptor() throws EarPluginException {
        File outputDir = new File(this.generatedDescriptorLocation);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File descriptor = new File(outputDir, "application.xml");
        ApplicationXmlWriter writer = new ApplicationXmlWriter(this.version, this.encoding);
        writer.write(descriptor, this.getModules(), this.displayName, this.description);
    }
}

