/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear.output;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.ear.output.FileNameMapping;
import org.apache.maven.plugin.ear.output.FullFileNameMapping;
import org.apache.maven.plugin.ear.output.StandardFileNameMapping;

public class FileNameMappingFactory {
    public static final String STANDARD_FILE_NAME_MAPPING = "standard";
    public static final String FULL_FILE_NAME_MAPPING = "full";
    public static final FileNameMappingFactory INSTANCE = new FileNameMappingFactory();
    private final Map mappings = new HashMap();
    static /* synthetic */ Class class$org$apache$maven$plugin$ear$output$FileNameMapping;

    private FileNameMappingFactory() {
        this.mappings.put(STANDARD_FILE_NAME_MAPPING, new StandardFileNameMapping());
        this.mappings.put(FULL_FILE_NAME_MAPPING, new FullFileNameMapping());
    }

    public FileNameMapping getDefaultFileNameMapping() {
        return this.getFileNameMapping(STANDARD_FILE_NAME_MAPPING);
    }

    public FileNameMapping getFileNameMapping(String nameOrClass) throws IllegalStateException {
        if (this.mappings.containsKey(nameOrClass)) {
            return (FileNameMapping)this.mappings.get(nameOrClass);
        }
        try {
            Class<?> c = Class.forName(nameOrClass);
            FileNameMapping fnm = (FileNameMapping)c.newInstance();
            this.mappings.put(nameOrClass, fnm);
            return fnm;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("File name mapping implementation[" + nameOrClass + "] was not found " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Could not instanciate file name mapping implementation[" + nameOrClass + "] make sure it has a default public constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access file name mapping implementation[" + nameOrClass + "] make sure it has a default public constructor");
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Specified class[" + nameOrClass + "] does not implement[" + (class$org$apache$maven$plugin$ear$output$FileNameMapping == null ? (class$org$apache$maven$plugin$ear$output$FileNameMapping = FileNameMappingFactory.class$("org.apache.maven.plugin.ear.output.FileNameMapping")) : class$org$apache$maven$plugin$ear$output$FileNameMapping).getName() + "]");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

