/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.ear.util.InvalidJavaEEVersion;

public class JavaEEVersion
implements Comparable {
    private static final String VERSION_1_3 = "1.3";
    private static final String VERSION_1_4 = "1.4";
    private static final String VERSION_5 = "5";
    private static final String VERSION_6 = "6";
    private static final Map versionsMap = new HashMap();
    public static final JavaEEVersion OneDotThree = new JavaEEVersion(new Integer(0), "1.3");
    public static final JavaEEVersion OneDotFour = new JavaEEVersion(new Integer(1), "1.4");
    public static final JavaEEVersion Five = new JavaEEVersion(new Integer(2), "5");
    public static final JavaEEVersion Six = new JavaEEVersion(new Integer(3), "6");
    private final Integer index;
    private final String version;

    private JavaEEVersion(Integer index, String version) {
        this.index = index;
        this.version = version;
        versionsMap.put(version, this);
    }

    public static JavaEEVersion getJavaEEVersion(String version) throws InvalidJavaEEVersion {
        if (!JavaEEVersion.isValid(version)) {
            throw new InvalidJavaEEVersion("Invalid version [" + version + "]", version);
        }
        return (JavaEEVersion)versionsMap.get(version);
    }

    public String getVersion() {
        return this.version;
    }

    public boolean ge(JavaEEVersion version) {
        return this.compareTo(version) >= 0;
    }

    public boolean gt(JavaEEVersion version) {
        return this.compareTo(version) > 0;
    }

    public boolean eq(JavaEEVersion version) {
        return this.compareTo(version) == 0;
    }

    public boolean le(JavaEEVersion version) {
        return this.compareTo(version) <= 0;
    }

    public boolean lt(JavaEEVersion version) {
        return this.compareTo(version) < 0;
    }

    private static boolean isValid(String version) {
        if (version == null) {
            throw new IllegalArgumentException("version could not be null.");
        }
        return VERSION_1_3.equals(version) || VERSION_1_4.equals(version) || VERSION_5.equals(version) || VERSION_6.equals(version);
    }

    public int compareTo(Object other) {
        if (other == null) {
            throw new IllegalArgumentException("other object to compare to could not be null.");
        }
        if (!(other instanceof JavaEEVersion)) {
            throw new IllegalArgumentException("other object to compare must be a JavaEEVersion but was [" + other.getClass().getName() + "]");
        }
        JavaEEVersion otherVersion = (JavaEEVersion)other;
        return this.index.compareTo(otherVersion.index);
    }
}

