/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.EarExecutionContext;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.EarModuleFactory;
import org.apache.maven.plugin.ear.EarPluginException;
import org.apache.maven.plugin.ear.JbossConfiguration;
import org.apache.maven.plugin.ear.util.ArtifactTypeMappingService;
import org.apache.maven.plugin.ear.util.JavaEEVersion;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEarMojo
extends AbstractMojo {
    public static final String APPLICATION_XML_URI = "META-INF/application.xml";
    public static final String META_INF = "META-INF";
    public static final String UTF_8 = "UTF-8";
    @Parameter(defaultValue="1.3")
    protected String version;
    @Parameter(defaultValue="UTF-8")
    protected String encoding;
    @Parameter(defaultValue="${project.build.directory}")
    protected String generatedDescriptorLocation;
    @Component
    protected MavenProject project;
    @Parameter
    private EarModule[] modules;
    @Parameter
    protected PlexusConfiguration artifactTypeMappings;
    @Parameter(alias="defaultJavaBundleDir")
    protected String defaultLibBundleDir;
    @Parameter(defaultValue="false")
    private Boolean includeLibInApplicationXml = Boolean.FALSE;
    @Parameter
    private String fileNameMapping;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    private File workDirectory;
    @Parameter
    private PlexusConfiguration jboss;
    @Parameter
    private String mainArtifactId = "none";
    private List<EarModule> earModules;
    private List<EarModule> allModules;
    private JbossConfiguration jbossConfiguration;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactTypeMappingService typeMappingService;
        JavaEEVersion javaEEVersion = JavaEEVersion.getJavaEEVersion(this.version);
        this.getLog().debug((CharSequence)"Resolving artifact type mappings ...");
        try {
            typeMappingService = new ArtifactTypeMappingService();
            typeMappingService.configure(this.artifactTypeMappings);
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to initialize artifact type mappings", (Exception)e);
        }
        catch (PlexusConfigurationException e) {
            throw new MojoExecutionException("Invalid artifact type mappings configuration", (Exception)((Object)e));
        }
        this.getLog().debug((CharSequence)"Initializing JBoss configuration if necessary ...");
        try {
            this.initializeJbossConfiguration();
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to initialize JBoss configuration", (Exception)e);
        }
        this.getLog().debug((CharSequence)"Initializing ear execution context");
        EarExecutionContext earExecutionContext = new EarExecutionContext(this.project, this.mainArtifactId, this.defaultLibBundleDir, this.jbossConfiguration, this.fileNameMapping, typeMappingService);
        this.getLog().debug((CharSequence)"Resolving ear modules ...");
        this.allModules = new ArrayList<EarModule>();
        try {
            if (this.modules != null && this.modules.length > 0) {
                EarModule module = null;
                for (int i = 0; i < this.modules.length; ++i) {
                    module = this.modules[i];
                    this.getLog().debug((CharSequence)("Resolving ear module[" + module + "]"));
                    module.setEarExecutionContext(earExecutionContext);
                    module.resolveArtifact(this.project.getArtifacts());
                    this.allModules.add(module);
                }
            }
            Set artifacts = this.project.getArtifacts();
            for (Artifact artifact : artifacts) {
                if ("pom".equals(artifact.getType())) continue;
                ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
                if (AbstractEarMojo.isArtifactRegistered(artifact, this.allModules) || artifact.isOptional() || !filter.include(artifact)) continue;
                EarModule module = EarModuleFactory.newEarModule(artifact, javaEEVersion, this.defaultLibBundleDir, this.includeLibInApplicationXml, typeMappingService);
                module.setEarExecutionContext(earExecutionContext);
                this.allModules.add(module);
            }
        }
        catch (EarPluginException e) {
            throw new MojoExecutionException("Failed to initialize ear modules", (Exception)e);
        }
        this.earModules = new ArrayList<EarModule>();
        for (EarModule earModule : this.allModules) {
            if (earModule.isExcluded()) {
                this.getLog().debug((CharSequence)("Skipping ear module[" + earModule + "]"));
                continue;
            }
            this.earModules.add(earModule);
        }
    }

    protected List<EarModule> getModules() {
        if (this.earModules == null) {
            throw new IllegalStateException("Ear modules have not been initialized");
        }
        return this.earModules;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected File getWorkDirectory() {
        return this.workDirectory;
    }

    protected JbossConfiguration getJbossConfiguration() {
        return this.jbossConfiguration;
    }

    private static boolean isArtifactRegistered(Artifact a, List<EarModule> currentList) {
        for (EarModule em : currentList) {
            if (!em.getArtifact().equals(a)) continue;
            return true;
        }
        return false;
    }

    private void initializeJbossConfiguration() throws EarPluginException {
        if (this.jboss == null) {
            this.jbossConfiguration = null;
        } else {
            try {
                String version = this.jboss.getChild("version").getValue();
                if (version == null) {
                    this.getLog().info((CharSequence)"JBoss version not set, using JBoss 4 by default");
                    version = "4";
                }
                String securityDomain = this.jboss.getChild("security-domain").getValue();
                String unauthenticatedPrincipal = this.jboss.getChild("unauthenticated-principal").getValue();
                PlexusConfiguration loaderRepositoryEl = this.jboss.getChild("loader-repository");
                String loaderRepository = loaderRepositoryEl.getValue();
                String loaderRepositoryClass = loaderRepositoryEl.getAttribute("loaderRepositoryClass");
                PlexusConfiguration loaderRepositoryConfigEl = this.jboss.getChild("loader-repository-config");
                String loaderRepositoryConfig = loaderRepositoryConfigEl.getValue();
                String configParserClass = loaderRepositoryConfigEl.getAttribute("configParserClass");
                String jmxName = this.jboss.getChild("jmx-name").getValue();
                String moduleOrder = this.jboss.getChild("module-order").getValue();
                ArrayList<String> dataSources = new ArrayList<String>();
                PlexusConfiguration dataSourcesEl = this.jboss.getChild("data-sources");
                if (dataSourcesEl != null) {
                    PlexusConfiguration[] dataSourcesConfig = dataSourcesEl.getChildren("data-source");
                    for (int i = 0; i < dataSourcesConfig.length; ++i) {
                        PlexusConfiguration dataSourceConfig = dataSourcesConfig[i];
                        dataSources.add(dataSourceConfig.getValue());
                    }
                }
                String libraryDirectory = this.jboss.getChild("library-directory").getValue();
                this.jbossConfiguration = new JbossConfiguration(version, securityDomain, unauthenticatedPrincipal, jmxName, loaderRepository, moduleOrder, dataSources, libraryDirectory, loaderRepositoryConfig, loaderRepositoryClass, configParserClass);
            }
            catch (PlexusConfigurationException e) {
                throw new EarPluginException("Invalid JBoss configuration", e);
            }
        }
    }
}

