/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.text.MessageFormat;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class EclipseCleanMojo
extends AbstractMojo {
    private File basedir;

    public void execute() throws MojoExecutionException {
        this.delete(new File(this.basedir, ".project"));
        this.delete(new File(this.basedir, ".classpath"));
        this.delete(new File(this.basedir, ".wtpmodules"));
    }

    private void delete(File f) throws MojoExecutionException {
        this.getLog().info((CharSequence)MessageFormat.format("Deleting {0} file...", f.getName()));
        if (f.exists()) {
            if (!f.delete()) {
                throw new MojoExecutionException(MessageFormat.format("Failed to delete {0} file: {0}", f.getName(), f.getAbsolutePath())){};
            }
        } else {
            this.getLog().info((CharSequence)MessageFormat.format("No {0} file found", f.getName()));
        }
    }
}

