/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseUtils;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseProjectWriter {
    private Log log;

    public EclipseProjectWriter(Log log) {
        this.log = log;
    }

    protected void write(File projectBaseDir, File basedir, MavenProject project, MavenProject executedProject, List reactorArtifacts, List projectnatures, List buildCommands) throws MojoExecutionException {
        FileWriter w;
        try {
            w = new FileWriter(new File(basedir, ".project"));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        writer.startElement("projectDescription");
        writer.startElement("name");
        writer.writeText(project.getArtifactId());
        writer.endElement();
        writer.startElement("comment");
        if (project.getDescription() != null) {
            writer.writeText(project.getDescription());
        }
        writer.endElement();
        writer.startElement("projects");
        Iterator it = reactorArtifacts.iterator();
        while (it.hasNext()) {
            writer.startElement("project");
            writer.writeText(((Artifact)it.next()).getArtifactId());
            writer.endElement();
        }
        writer.endElement();
        writer.startElement("buildSpec");
        it = buildCommands.iterator();
        while (it.hasNext()) {
            writer.startElement("buildCommand");
            writer.startElement("name");
            writer.writeText((String)it.next());
            writer.endElement();
            writer.startElement("arguments");
            writer.endElement();
            writer.endElement();
        }
        writer.endElement();
        writer.startElement("natures");
        it = projectnatures.iterator();
        while (it.hasNext()) {
            writer.startElement("nature");
            writer.writeText((String)it.next());
            writer.endElement();
        }
        writer.endElement();
        if (!projectBaseDir.equals(basedir)) {
            writer.startElement("linkedResources");
            this.addFileLink((XMLWriter)writer, projectBaseDir, basedir, project.getFile());
            this.addSourceLinks((XMLWriter)writer, projectBaseDir, basedir, executedProject.getCompileSourceRoots());
            this.addResourceLinks((XMLWriter)writer, projectBaseDir, basedir, executedProject.getBuild().getResources());
            this.addSourceLinks((XMLWriter)writer, projectBaseDir, basedir, executedProject.getTestCompileSourceRoots());
            this.addResourceLinks((XMLWriter)writer, projectBaseDir, basedir, executedProject.getBuild().getTestResources());
            writer.endElement();
        }
        writer.endElement();
        IOUtil.close((Writer)w);
    }

    private void addFileLink(XMLWriter writer, File projectBaseDir, File basedir, File file) {
        if (file.isFile()) {
            writer.startElement("link");
            writer.startElement("name");
            writer.writeText(EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, file.toString(), true));
            writer.endElement();
            writer.startElement("type");
            writer.writeText("1");
            writer.endElement();
            writer.startElement("location");
            writer.writeText(file.toString().replaceAll("\\\\", "/"));
            writer.endElement();
            writer.endElement();
        } else {
            this.log.warn((CharSequence)Messages.getString("EclipseProjectWriter.notafile", file));
        }
    }

    private void addSourceLinks(XMLWriter writer, File projectBaseDir, File basedir, List sourceRoots) {
        Iterator it = sourceRoots.iterator();
        while (it.hasNext()) {
            String sourceRoot = (String)it.next();
            if (!new File(sourceRoot).isDirectory()) continue;
            writer.startElement("link");
            writer.startElement("name");
            writer.writeText(EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, sourceRoot, true));
            writer.endElement();
            writer.startElement("type");
            writer.writeText("2");
            writer.endElement();
            writer.startElement("location");
            writer.writeText(sourceRoot.replaceAll("\\\\", "/"));
            writer.endElement();
            writer.endElement();
        }
    }

    private void addResourceLinks(XMLWriter writer, File projectBaseDir, File basedir, List sourceRoots) {
        Iterator it = sourceRoots.iterator();
        while (it.hasNext()) {
            String resourceDir = ((Resource)it.next()).getDirectory();
            if (!new File(resourceDir).isDirectory()) continue;
            writer.startElement("link");
            writer.startElement("name");
            writer.writeText(EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, resourceDir, true));
            writer.endElement();
            writer.startElement("type");
            writer.writeText("2");
            writer.endElement();
            writer.startElement("location");
            writer.writeText(resourceDir.replaceAll("\\\\", "/"));
            writer.endElement();
            writer.endElement();
        }
    }
}

