/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class EclipseUtils {
    private EclipseUtils() {
    }

    public static String toRelativeAndFixSeparator(File basedir, String absolutePath, boolean replaceSlashes) {
        String relative = absolutePath.equals(basedir.getAbsolutePath()) ? "." : (absolutePath.startsWith(basedir.getAbsolutePath()) ? absolutePath.substring(basedir.getAbsolutePath().length() + 1) : absolutePath);
        relative = StringUtils.replace((String)relative, (String)"\\", (String)"/");
        if (replaceSlashes) {
            relative = StringUtils.replace((String)relative, (String)"/", (String)"-");
        }
        return relative;
    }

    public static String getPluginSetting(MavenProject project, String artifactId, String optionName, String defaultValue) {
        Iterator it = project.getModel().getBuild().getPlugins().iterator();
        while (it.hasNext()) {
            Xpp3Dom o;
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getArtifactId().equals(artifactId) || (o = (Xpp3Dom)plugin.getConfiguration()) == null || o.getChild(optionName) == null) continue;
            return o.getChild(optionName).getValue();
        }
        return defaultValue;
    }

    public static EclipseSourceDir[] buildDirectoryList(MavenProject project, File basedir, Log log, String outputDirectory) {
        File projectBaseDir = project.getFile().getParentFile();
        TreeSet directories = new TreeSet();
        EclipseUtils.extractSourceDirs(directories, project.getCompileSourceRoots(), basedir, projectBaseDir, false, null);
        EclipseUtils.extractResourceDirs(directories, project.getBuild().getResources(), project, basedir, projectBaseDir, false, null, log);
        String testOutput = outputDirectory.equals(project.getBuild().getOutputDirectory()) ? EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, project.getBuild().getTestOutputDirectory(), false) : null;
        EclipseUtils.extractSourceDirs(directories, project.getTestCompileSourceRoots(), basedir, projectBaseDir, true, testOutput);
        EclipseUtils.extractResourceDirs(directories, project.getBuild().getTestResources(), project, basedir, projectBaseDir, true, testOutput, log);
        return directories.toArray(new EclipseSourceDir[directories.size()]);
    }

    private static void extractSourceDirs(Set directories, List sourceRoots, File basedir, File projectBaseDir, boolean test, String output) {
        Iterator it = sourceRoots.iterator();
        while (it.hasNext()) {
            String sourceRoot = (String)it.next();
            if (!new File(sourceRoot).isDirectory()) continue;
            sourceRoot = EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, sourceRoot, !projectBaseDir.equals(basedir));
            directories.add(new EclipseSourceDir(sourceRoot, output, test, null, null));
        }
    }

    private static void extractResourceDirs(Set directories, List resources, MavenProject project, File basedir, File projectBaseDir, boolean test, String output, Log log) {
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            File resourceDirectory;
            Resource resource = (Resource)it.next();
            String includePattern = null;
            String excludePattern = null;
            if (resource.getIncludes().size() != 0) {
                log.warn((CharSequence)Messages.getString("EclipsePlugin.includenotsupported"));
            }
            if (resource.getExcludes().size() != 0) {
                log.warn((CharSequence)Messages.getString("EclipsePlugin.excludenotsupported"));
            }
            if (!StringUtils.isEmpty((String)resource.getTargetPath())) {
                output = resource.getTargetPath();
            }
            if (!(resourceDirectory = new File(resource.getDirectory())).exists() || !resourceDirectory.isDirectory()) continue;
            String resourceDir = resource.getDirectory();
            resourceDir = EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, resourceDir, !projectBaseDir.equals(basedir));
            if (output != null) {
                output = EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, output, false);
            }
            directories.add(new EclipseSourceDir(resourceDir, output, test, includePattern, excludePattern));
        }
    }

    public static MavenProject findReactorProject(List reactorProjects, Artifact artifact) {
        if (reactorProjects == null) {
            return null;
        }
        Iterator it = reactorProjects.iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            if (!project.getGroupId().equals(artifact.getGroupId()) || !project.getArtifactId().equals(artifact.getArtifactId()) || !project.getVersion().equals(artifact.getVersion())) continue;
            return project;
        }
        return null;
    }

    public static List resolveReactorArtifacts(MavenProject project, List reactorProjects) {
        ArrayList<Artifact> referencedProjects = new ArrayList<Artifact>();
        Set artifacts = project.getArtifacts();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            MavenProject refProject = EclipseUtils.findReactorProject(reactorProjects, artifact);
            if (refProject == null) continue;
            referencedProjects.add(artifact);
        }
        return referencedProjects;
    }
}

