/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.EclipseUtils;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseWtpmodulesWriter {
    private Log log;

    public EclipseWtpmodulesWriter(Log log) {
        this.log = log;
    }

    protected void write(File basedir, MavenProject project, List referencedReactorArtifacts, EclipseSourceDir[] sourceDirs, ArtifactRepository localRepository) throws MojoExecutionException {
        FileWriter w;
        try {
            w = new FileWriter(new File(basedir, ".wtpmodules"));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        writer.startElement("project-modules");
        writer.addAttribute("id", "moduleCoreId");
        writer.startElement("wb-module");
        writer.addAttribute("deploy-name", project.getArtifactId());
        writer.startElement("module-type");
        if ("war".equals(project.getPackaging())) {
            writer.addAttribute("module-type-id", "jst.web");
            writer.startElement("version");
            String servletVersion = "2.4";
            Iterator it = project.getArtifacts().iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                if (!"servletapi".equals(artifact.getArtifactId()) && !"geronimo-spec-servlet".equals(artifact.getArtifactId())) continue;
                servletVersion = StringUtils.substring((String)artifact.getVersion(), (int)0, (int)3);
            }
            writer.writeText(servletVersion);
            writer.endElement();
            writer.startElement("property");
            writer.addAttribute("name", "context-root");
            writer.addAttribute("value", project.getArtifactId());
            writer.endElement();
        } else if ("ejb".equals(project.getPackaging())) {
            writer.addAttribute("module-type-id", "jst.ejb");
            writer.startElement("version");
            writer.writeText("2.1");
            writer.endElement();
            writer.startElement("property");
            writer.addAttribute("name", "java-output-path");
            writer.addAttribute("value", "/" + EclipseUtils.toRelativeAndFixSeparator(project.getBasedir(), project.getBuild().getOutputDirectory(), false));
            writer.endElement();
        } else {
            writer.addAttribute("module-type-id", "jst.utility");
            writer.startElement("property");
            writer.addAttribute("name", "java-output-path");
            writer.addAttribute("value", "/" + EclipseUtils.toRelativeAndFixSeparator(project.getBasedir(), project.getBuild().getOutputDirectory(), false));
            writer.endElement();
        }
        writer.endElement();
        String target = "/";
        if ("war".equals(project.getPackaging())) {
            this.writeWarSpecificResources((XMLWriter)writer, basedir, project, referencedReactorArtifacts, localRepository);
            target = "/WEB-INF/classes";
        }
        for (int j = 0; j < sourceDirs.length; ++j) {
            EclipseSourceDir dir = sourceDirs[j];
            if (dir.isTest()) continue;
            writer.startElement("wb-resource");
            writer.addAttribute("deploy-path", target);
            writer.addAttribute("source-path", dir.getPath());
            writer.endElement();
        }
        writer.endElement();
        writer.endElement();
        IOUtil.close((Writer)w);
    }

    private void writeWarSpecificResources(XMLWriter writer, File basedir, MavenProject project, List referencedReactorArtifacts, ArtifactRepository localRepository) {
        String warSourceDirectory = EclipseUtils.getPluginSetting(project, "maven-war-plugin", "warSourceDirectory", "/src/main/webapp");
        writer.startElement("wb-resource");
        writer.addAttribute("deploy-path", "/");
        writer.addAttribute("source-path", EclipseUtils.toRelativeAndFixSeparator(basedir, warSourceDirectory, false));
        writer.endElement();
        Iterator it = project.getArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            this.addDependency(writer, artifact, referencedReactorArtifacts, localRepository);
        }
    }

    private void addDependency(XMLWriter writer, Artifact artifact, List referencedReactorProjects, ArtifactRepository localRepository) {
        String handle;
        if (referencedReactorProjects.contains(artifact)) {
            handle = "module:/resource/" + artifact.getArtifactId() + "/" + artifact.getArtifactId();
        } else {
            File artifactPath = artifact.getFile();
            if (artifactPath == null) {
                this.log.error((CharSequence)Messages.getString("EclipsePlugin.artifactpathisnull", artifact.getId()));
                return;
            }
            String fullPath = artifactPath.getPath();
            File localRepositoryFile = new File(localRepository.getBasedir());
            handle = "module:/classpath/var/M2_REPO/" + EclipseUtils.toRelativeAndFixSeparator(localRepositoryFile, fullPath, false);
        }
        writer.startElement("dependent-module");
        writer.addAttribute("deploy-path", "/WEB-INF/lib");
        writer.addAttribute("handle", handle);
        writer.startElement("dependency-type");
        writer.writeText("uses");
        writer.endElement();
        writer.endElement();
    }
}

