/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;

public class EclipseAjdtWriter
extends AbstractEclipseWriter {
    private static final String LIBRARY = "LIBRARY";
    private static final String BINARY = "BINARY";
    private static final String CONTENT_KIND = ".contentKind";
    private static final String ENTRY_KIND = ".entryKind";
    private static final String FILE_AJDT_PREFS = "org.eclipse.ajdt.ui.prefs";
    private static final String PROP_ECLIPSE_PREFERENCES_VERSION = "eclipse.preferences.version";
    private static final String DIR_DOT_SETTINGS = ".settings";
    private static final String AJDT_PROP_PREFIX = "org.eclipse.ajdt.ui.";
    private static final String ASPECT_DEP_PROP = "aspectPath";
    private static final String WEAVE_DEP_PROP = "inPath";

    public void write() throws MojoExecutionException {
        Properties ajdtSettings = new Properties();
        IdeDependency[] deps = this.config.getDeps();
        int ajdtDepCount = 0;
        int ajdtWeaveDepCount = 0;
        for (IdeDependency dep : deps) {
            if (dep.isAjdtDependency()) {
                this.addDependency(ajdtSettings, dep, ASPECT_DEP_PROP, ++ajdtDepCount);
            }
            if (!dep.isAjdtWeaveDependency()) continue;
            this.addDependency(ajdtSettings, dep, WEAVE_DEP_PROP, ++ajdtWeaveDepCount);
        }
        if (!ajdtSettings.isEmpty()) {
            File settingsDir = new File(this.config.getEclipseProjectDirectory(), DIR_DOT_SETTINGS);
            settingsDir.mkdirs();
            ajdtSettings.put(PROP_ECLIPSE_PREFERENCES_VERSION, "1");
            try {
                File ajdtSettingsFile = new File(settingsDir, FILE_AJDT_PREFS);
                if (ajdtSettingsFile.exists()) {
                    File oldAjdtSettingsFile = ajdtSettingsFile;
                    Properties oldsettings = new Properties();
                    oldsettings.load(new FileInputStream(oldAjdtSettingsFile));
                    Properties newsettings = (Properties)oldsettings.clone();
                    newsettings.putAll((Map<?, ?>)ajdtSettings);
                    if (!oldsettings.equals(newsettings)) {
                        newsettings.store(new FileOutputStream(ajdtSettingsFile), null);
                    }
                } else {
                    ajdtSettings.store(new FileOutputStream(ajdtSettingsFile), null);
                    this.log.info((CharSequence)Messages.getString("EclipseSettingsWriter.wrotesettings", ajdtSettingsFile.getCanonicalPath()));
                }
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException(Messages.getString("EclipseSettingsWriter.cannotcreatesettings"), (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Messages.getString("EclipseSettingsWriter.errorwritingsettings"), (Exception)e);
            }
        }
    }

    private void addDependency(Properties ajdtSettings, IdeDependency dep, String propName, int index) throws MojoExecutionException {
        String path;
        if (dep.isReferencedProject() && !this.config.isPde()) {
            path = "/" + dep.getEclipseProjectName();
        } else {
            if (dep.isReferencedProject() && this.config.isPde()) {
                return;
            }
            File artifactPath = dep.getFile();
            if (artifactPath == null) {
                this.log.error((CharSequence)Messages.getString("EclipsePlugin.artifactpathisnull", dep.getId()));
                return;
            }
            if (dep.isSystemScoped()) {
                path = IdeUtils.toRelativeAndFixSeparator(this.config.getEclipseProjectDirectory(), artifactPath, false);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)Messages.getString("EclipsePlugin.artifactissystemscoped", new Object[]{dep.getArtifactId(), path}));
                }
            } else {
                String fullPath;
                String relativePath;
                File localRepositoryFile = new File(this.config.getLocalRepository().getBasedir());
                if (this.config.isPde() && (dep.isProvided() || dep.isOsgiBundle())) {
                    return;
                }
                path = this.config.isPde() && !dep.isProvided() && !dep.isTestDependency() ? dep.getFile().getName() : (!new File(relativePath = IdeUtils.toRelativeAndFixSeparator(localRepositoryFile, new File(fullPath = artifactPath.getPath()), false)).isAbsolute() ? "M2_REPO/" + relativePath : relativePath);
            }
        }
        ajdtSettings.setProperty(AJDT_PROP_PREFIX + propName + CONTENT_KIND + index, BINARY);
        ajdtSettings.setProperty(AJDT_PROP_PREFIX + propName + ENTRY_KIND + index, LIBRARY);
        ajdtSettings.setProperty(AJDT_PROP_PREFIX + propName + index, path);
    }
}

