/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.exoplatform.maven2.plugin.DeployCommand;
import org.exoplatform.maven2.plugin.DeployConfiguration;
import org.exoplatform.maven2.plugin.ExoFileUtils;
import org.exoplatform.maven2.plugin.PackagingCommand;
import org.exoplatform.maven2.plugin.PackagingConfiguration;
import org.exoplatform.maven2.plugin.ProjectUtils;
import org.exoplatform.maven2.plugin.ReleaseCommand;
import org.exoplatform.maven2.plugin.ReleaseConfiguration;
import org.exoplatform.tools.xml.webapp.v23.ModifyWebXMLOperation;

public class Command {

    static class ReleaseSrcCode
    extends ReleaseCommand {
        ReleaseSrcCode() {
        }

        public void execute(ReleaseConfiguration releaseConfig) throws Exception {
            File sourceDirectory = new File(releaseConfig.getSourceDirectory());
            File releaseDirectory = new File(releaseConfig.getReleaseDirectory());
            if (!releaseDirectory.exists()) {
                releaseDirectory.mkdirs();
            }
            File releaseSrcFile = new File(releaseConfig.getReleaseDirectory() + "/" + releaseConfig.getReleaseSrcName() + ".zip");
            ExoFileUtils.addToArchive(sourceDirectory, releaseSrcFile, releaseConfig.getIgnoredFiles());
            ProjectUtils.printMessage("archive", "  Created src file zip to " + releaseSrcFile.getParent());
        }
    }

    static class DeleteTempInTomcat
    extends ReleaseCommand {
        DeleteTempInTomcat() {
        }

        public void execute(ReleaseConfiguration releaseConfig) throws Exception {
            File deployTomcatDir = new File(releaseConfig.getDeployDirectory());
            if (!deployTomcatDir.exists()) {
                System.out.println("    The directory" + deployTomcatDir.getPath() + " is does not exists !\n " + "   You must deploy project before release it !");
                throw new MojoExecutionException("");
            }
            HashSet<File> dirContaintTemps = new HashSet<File>();
            dirContaintTemps.add(new File(deployTomcatDir.getPath() + "/work"));
            dirContaintTemps.add(new File(deployTomcatDir.getPath() + "/temp"));
            dirContaintTemps.add(new File(deployTomcatDir.getPath() + "/logs"));
            for (File dirContaintTemp : dirContaintTemps) {
                ExoFileUtils.deleteContentInDirectory(dirContaintTemp);
            }
            File webappDir = new File(deployTomcatDir + "/webapps");
            File[] files = webappDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory() || !ExoFileUtils.containtFile(webappDir, files[i].getName() + ".war")) continue;
                ExoFileUtils.deleteDirectory((File)files[i]);
            }
        }
    }

    static class ReleaseProject
    extends ReleaseCommand {
        ReleaseProject() {
        }

        public void execute(ReleaseConfiguration releaseConfig) throws Exception {
            File deployDirectory = new File(releaseConfig.getDeployDirectory());
            if (!deployDirectory.exists()) {
                System.out.println("   The directory" + deployDirectory.getPath() + " is does not exists !\n " + "   You must deploy project before release it !");
                throw new MojoExecutionException("");
            }
            File releaseDirectory = new File(releaseConfig.getReleaseDirectory());
            if (!releaseDirectory.exists()) {
                releaseDirectory.mkdirs();
            }
            File releaseFile = new File(releaseConfig.getReleaseDirectory() + "/" + releaseConfig.getReleaseFileName() + ".zip");
            ExoFileUtils.addToArchive(deployDirectory, releaseFile);
            ProjectUtils.printMessage("archive", "  Created 1 file zip to " + releaseFile.getParent());
        }
    }

    static class DeployToJonas
    extends DeployCommand {
        DeployToJonas() {
        }

        public void execute(DeployConfiguration dconfig) throws Exception {
            String deployJonasDir = dconfig.getDeployServerDir();
            MavenProject project = dconfig.getMavenProject();
            File earDir = new File(deployJonasDir + "/apps/autoload/exoplatform.ear");
            File libDir = new File(deployJonasDir + "/lib/apps");
            earDir.mkdirs();
            libDir.mkdirs();
            ProjectUtils.deployProject(libDir, earDir, project, "all", dconfig.getIgnoredProjects());
        }
    }

    static class CreateEarApplicationXml
    extends DeployCommand {
        CreateEarApplicationXml() {
        }

        public void execute(DeployConfiguration dconfig) throws Exception {
            if (dconfig.getMavenProject().getPackaging().equals("exo-product")) {
                File earDir = new File(dconfig.getDeployWebappDir());
                File metaInfDir = new File(earDir.getPath() + "/META-INF");
                if (!metaInfDir.exists()) {
                    metaInfDir.mkdirs();
                }
                StringBuilder b = new StringBuilder();
                b.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                b.append("<!DOCTYPE application PUBLIC \"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN\" \"http://java.sun.com/dtd/application_1_3.dtd\">");
                b.append("\n<application>\n");
                b.append("  <display-name>exoplatform</display-name>\n");
                String[] file = earDir.list();
                for (int i = 0; i < file.length; ++i) {
                    if (!file[i].endsWith("war")) continue;
                    int idx = file[i].indexOf(46);
                    String context = file[i].substring(0, idx);
                    b.append("  <module>\n");
                    b.append("    <web>\n");
                    b.append("      <web-uri>").append(file[i]).append("</web-uri>\n");
                    b.append("      <context-root>").append(context).append("</context-root>\n");
                    b.append("    </web>\n");
                    b.append("  </module>\n");
                }
                b.append("</application>\n");
                FileOutputStream out = new FileOutputStream(metaInfDir.getPath() + "/application.xml");
                out.write(b.toString().getBytes());
                out.close();
            }
        }
    }

    static class CreateManifest
    extends DeployCommand {
        CreateManifest() {
        }

        public void execute(DeployConfiguration dconfig) throws Exception {
            File[] files;
            StringBuilder b = new StringBuilder();
            MavenProject project = dconfig.getMavenProject();
            File deployWebappDir = new File(dconfig.getDeployLibDir());
            for (File file : files = deployWebappDir.listFiles()) {
                if (!file.getName().endsWith(".jar")) continue;
                b.append(file.getName()).append(' ');
            }
            File warFile = new File(dconfig.getDeployWebappDir() + "/" + project.getBuild().getFinalName() + ".war");
            String type = dconfig.getMavenProject().getPackaging();
            if ("exo-portal".equals(type) || "exo-war".equals(type) || "exo-portlet".equals(type)) {
                this.modifyManifest(warFile, b);
            } else if ("exo-product".equals(type)) {
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().endsWith(".war")) continue;
                    this.modifyManifest(files[i], b);
                }
            }
        }

        private void modifyManifest(File warFile, StringBuilder b) throws Exception {
            JarFile jar = new JarFile(warFile);
            Manifest mf = jar.getManifest();
            mf.getMainAttributes().putValue("Class-Path", b.toString());
            File tmpFile = new File(warFile.getPath() + ".tmp");
            JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(tmpFile), mf);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                int bytesRead;
                JarEntry entry = entries.nextElement();
                byte[] buffer = new byte[1024];
                InputStream entryStream = jar.getInputStream(entry);
                if (entry.getName().endsWith("MANIFEST.MF")) continue;
                jos.putNextEntry(entry);
                while ((bytesRead = entryStream.read(buffer)) != -1) {
                    jos.write(buffer, 0, bytesRead);
                }
            }
            jar.close();
            jos.close();
            warFile.delete();
            tmpFile.renameTo(warFile);
        }
    }

    static class PatchConfigJboss
    extends DeployCommand {
        PatchConfigJboss() {
        }

        public void execute(DeployConfiguration dconfig) throws Exception {
            File earDir = new File(dconfig.getDeployServerDir() + "/server/default/deploy/exoplatform.sar");
            String sharedResourcesDir = dconfig.getServerConfig();
            ExoFileUtils.copyDirectoryStructure(new File(sharedResourcesDir + "/exoplatform.sar"), earDir, dconfig.getIgnoredFiles());
            ProjectUtils.printMessage("copy", "    Prepared sar configuration from " + earDir.getName());
        }
    }

    static class CreatePortalXml
    extends DeployCommand {
        CreatePortalXml() {
        }

        public void execute(DeployConfiguration dconfig) throws Exception {
            MavenProject project = dconfig.getMavenProject();
            if (!dconfig.getMavenProject().getPackaging().equals("exo-product")) {
                return;
            }
            Set artifacts = project.getArtifacts();
            for (DefaultArtifact da : artifacts) {
                String projectType = da.getType();
                if (!projectType.equals("exo-portal")) continue;
                String deployTomcatDir = dconfig.getDeployServerDir();
                String contextName = da.getArtifactId();
                if ((contextName = contextName.substring(da.getGroupId().length() + 1, contextName.length())).indexOf(".") > 0) {
                    contextName = contextName.substring(contextName.indexOf(".") + 1, contextName.length());
                }
                FileInputStream is = new FileInputStream(deployTomcatDir + "/conf/Catalina/localhost/portal.template");
                byte[] buf = new byte[is.available()];
                is.read(buf);
                is.close();
                String s = new String(buf).replace("@context@", contextName);
                FileOutputStream os = new FileOutputStream(deployTomcatDir + "/conf/Catalina/localhost/" + contextName + ".xml");
                os.write(s.getBytes());
                os.close();
            }
        }
    }

    static class PatchServerConfig
    extends DeployCommand {
        PatchServerConfig() {
        }

        public void execute(DeployConfiguration dconfig) throws Exception {
            if (dconfig.isUseCleanServer()) {
                File deployServerDir = new File(dconfig.getDeployServerDir());
                List<String> serverPatchs = dconfig.getServerPatchs();
                if (serverPatchs == null) {
                    ProjectUtils.printMessage("info", " You do not specify custom server patch directories.............");
                } else {
                    for (String customDir : serverPatchs) {
                        File customDirectory = new File(customDir);
                        ExoFileUtils.copyDirectoryStructure(customDirectory, deployServerDir, dconfig.getIgnoredFiles(), true);
                        ProjectUtils.printMessage("info", " Copy custom " + customDirectory.getName() + " directory to " + customDirectory.getPath());
                    }
                }
            }
        }
    }

    static class NewServer
    extends DeployCommand {
        NewServer() {
        }

        public void execute(DeployConfiguration dconfig) throws Exception {
            if (dconfig.isUseCleanServer()) {
                File deployServerDirectory = new File(dconfig.getDeployServerDir());
                File cleanServerDirectory = new File(dconfig.getCleanServerDir());
                if (deployServerDirectory.exists()) {
                    ProjectUtils.printMessage("deleting", "  Deleting directory " + deployServerDirectory.getPath());
                    ExoFileUtils.deleteDirectory((File)deployServerDirectory);
                }
                ProjectUtils.printMessage("mkdir", "  " + deployServerDirectory.getPath());
                ProjectUtils.printMessage("copy", "  Copy directory " + cleanServerDirectory.getName() + " to " + deployServerDirectory.getPath());
                ExoFileUtils.copyDirectoryStructure((File)cleanServerDirectory, (File)deployServerDirectory);
            }
        }
    }

    static class DeployProject
    extends DeployCommand {
        DeployProject() {
        }

        public void execute(DeployConfiguration deployConfig) throws Exception {
            String scope = deployConfig.getDeployDependencyScope();
            try {
                if (scope != null && scope.equalsIgnoreCase("resources")) {
                    this.deployResource(deployConfig);
                    return;
                }
                this.deployModule(deployConfig);
                if (scope != null) {
                    if (scope.equalsIgnoreCase("all")) {
                        this.deployDependencies(deployConfig, "all");
                    } else if (scope.equalsIgnoreCase("compile")) {
                        this.deployDependencies(deployConfig, "compile");
                    } else if (scope.equalsIgnoreCase("runtime")) {
                        this.deployDependencies(deployConfig, "runtime");
                    }
                }
                return;
            }
            catch (Exception exception) {
                this.printInfo();
                return;
            }
        }

        public void deployModule(DeployConfiguration deployConfig) throws Exception {
            MavenProject project = deployConfig.getMavenProject();
            if (project.getPackaging().equals("exo-product")) {
                this.deployDependencies(deployConfig, "all");
                return;
            }
            System.out.println("==========================================================================\n                   DEPLOY MODULE  " + project.getArtifactId() + "         \n " + "==========================================================================\n");
            ProjectUtils.deployProject(deployConfig);
        }

        public void deployDependencies(DeployConfiguration deployConfig, String scope) throws Exception {
            HashSet<String> ignoreProjects = deployConfig.getIgnoredProjects();
            ProjectUtils.deployDependencies(deployConfig, scope, ignoreProjects);
        }

        private boolean deployResource(DeployConfiguration deployConfig) throws IOException {
            MavenProject project = deployConfig.getMavenProject();
            String packaging = project.getPackaging();
            String serverWebappDir = deployConfig.getDeployWebappDir();
            if (packaging.equals("jar")) {
                int groovyCounter;
                File srcDirectory = new File(project.getBasedir() + "/src/java");
                if (!srcDirectory.exists()) {
                    return true;
                }
                File portalDir = new File(deployConfig.getDefaultPortalDir());
                if (!portalDir.exists()) {
                    System.out.println("The directory" + portalDir + " is does not exists !");
                    return false;
                }
                File destVelocityDir = new File(deployConfig.getDefaultPortalDir() + "/velocity");
                File destGroovyDir = new File(deployConfig.getDefaultPortalDir() + "/groovy");
                int denum = ProjectUtils.deployResourceFiles(srcDirectory, destVelocityDir, deployConfig.getIgnoredFiles(), ProjectUtils.velocityFiles());
                if (denum > 0) {
                    ProjectUtils.printMessage("copy", "copied " + denum + " file to directory " + destVelocityDir + ".");
                }
                if ((groovyCounter = ProjectUtils.deployResourceFiles(srcDirectory, destGroovyDir, deployConfig.getIgnoredFiles(), ProjectUtils.groovyFiles())) > 0) {
                    ProjectUtils.printMessage("copy", "copied " + groovyCounter + " file to directory " + destGroovyDir + ".");
                }
            } else if (packaging.equals("exo-war") || packaging.equals("exo-portal") || packaging.equals("exo-portlet")) {
                File resourceDir = new File(serverWebappDir + "/" + project.getBuild().getFinalName());
                if (!resourceDir.exists()) {
                    System.out.println("The directory" + resourceDir + " is does not exists !");
                    return false;
                }
                File deployResourceDir = new File(project.getBasedir().toString() + "/src/webapp");
                if (deployResourceDir.exists()) {
                    int counter = ExoFileUtils.copyDirectoryStructure(deployResourceDir, resourceDir, deployConfig.getIgnoredFiles(), false);
                    if (counter > 0) {
                        ProjectUtils.printMessage("copy", "copied " + counter + " file to directory " + resourceDir + ".");
                    }
                } else {
                    System.out.println("The directory" + deployResourceDir.toString() + " is does not exists !");
                    return false;
                }
                if (packaging.equals("exo-portlet")) {
                    int groovyCounter;
                    File srcDirectory = new File(project.getBasedir() + "/src/java");
                    if (!srcDirectory.exists()) {
                        return true;
                    }
                    if (!resourceDir.exists()) {
                        System.out.println("The directory" + resourceDir.getPath() + " is does not exists !");
                        return false;
                    }
                    File destVelocityDir = new File(resourceDir.getPath() + "/velocity");
                    File destGroovyDir = new File(resourceDir.getPath() + "/groovy");
                    int denum = ProjectUtils.deployResourceFiles(srcDirectory, destVelocityDir, deployConfig.getIgnoredFiles(), ProjectUtils.velocityFiles());
                    if (denum > 0) {
                        ProjectUtils.printMessage("copy", "copied " + denum + " file to directory " + destVelocityDir + ".");
                    }
                    if ((groovyCounter = ProjectUtils.deployResourceFiles(srcDirectory, destGroovyDir, deployConfig.getIgnoredFiles(), ProjectUtils.groovyFiles())) > 0) {
                        ProjectUtils.printMessage("copy", "copied " + groovyCounter + " file to directory " + destGroovyDir + ".");
                    }
                }
                return true;
            }
            return true;
        }

        private void printInfo() throws MojoExecutionException {
            String info = "The 'exo:module  maven plugin is used to deploy project and dependencies  to the working server.\n";
            System.out.println(info);
            throw new MojoExecutionException("");
        }
    }

    static class PrepareBPARDir
    extends PackagingCommand {
        PrepareBPARDir() {
        }

        public void execute(PackagingConfiguration pconfig) throws Exception {
            MavenProject project = pconfig.getMavenProject();
            String templateLoc = pconfig.getOutputDirectory() + "/" + pconfig.getOutputFileName();
            File templateDir = new File(templateLoc);
            File confDir = new File(project.getBasedir() + "/src/conf");
            ExoFileUtils.copyDirectoryStructure(confDir, templateDir, pconfig.getIgnoredFiles());
            File classesSrc = new File(pconfig.getOutputDirectory() + "/classes");
            if (classesSrc.exists()) {
                ExoFileUtils.copyDirectoryStructure((File)classesSrc, (File)new File(templateLoc + "/classes"));
            }
        }
    }

    static class JarArchive
    extends PackagingCommand {
        JarArchive() {
        }

        public void execute(PackagingConfiguration pconfig) throws Exception {
            ProjectUtils.printMessage("info", "Archive jar file");
            String ftype = pconfig.getMavenProject().getPackaging();
            String sourcePath = pconfig.getOutputDirectory() + "/" + pconfig.getOutputFileName();
            File sourceDir = new File(sourcePath);
            File destFile = new File(sourcePath + "." + ftype);
            MavenArchiver archiver = new MavenArchiver();
            JarArchiver jarArchiver = new JarArchiver();
            archiver.setArchiver(jarArchiver);
            archiver.setOutputFile(destFile);
            jarArchiver.addDirectory(sourceDir);
            archiver.createArchive(pconfig.getMavenProject(), new MavenArchiveConfiguration());
            pconfig.getMavenProject().getArtifact().setFile(destFile);
        }
    }

    static class WarArchive
    extends PackagingCommand {
        WarArchive() {
        }

        public void execute(PackagingConfiguration pconfig) throws Exception {
            ProjectUtils.printMessage("info", "Archive war file");
            String sourcePath = pconfig.getOutputDirectory() + "/" + pconfig.getOutputFileName();
            File sourceFile = new File(sourcePath);
            File warFile = new File(sourcePath + ".war");
            MavenArchiver archiver = new MavenArchiver();
            WarArchiver warArchiver = new WarArchiver();
            archiver.setArchiver((JarArchiver)warArchiver);
            archiver.setOutputFile(warFile);
            warArchiver.addDirectory(sourceFile);
            warArchiver.setWebxml(new File(sourceFile, "WEB-INF/web.xml"));
            archiver.createArchive(pconfig.getMavenProject(), new MavenArchiveConfiguration());
            pconfig.getMavenProject().getArtifact().setFile(warFile);
        }
    }

    static class AddExoPortletDeployer
    extends PackagingCommand {
        AddExoPortletDeployer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(PackagingConfiguration pconfig) throws Exception {
            if (pconfig.getMavenProject().getPackaging().equalsIgnoreCase("exo-portlet")) {
                String webxml = pconfig.getOutputDirectory() + "/" + pconfig.getOutputFileName() + "/WEB-INF/web.xml";
                String warName = pconfig.getOutputFileName();
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(ModifyWebXMLOperation.class.getClassLoader());
                ModifyWebXMLOperation op = new ModifyWebXMLOperation(warName);
                File inputFile = new File(webxml);
                File outputFile = new File(webxml);
                try {
                    op.modifyWebXML(inputFile, outputFile);
                    ProjectUtils.printMessage("info", "Modified web.xml");
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            } else {
                return;
            }
        }
    }

    static class CopyFilesResource
    extends PackagingCommand {
        CopyFilesResource() {
        }

        public void execute(PackagingConfiguration pconfig) throws Exception {
            int groovyCounter;
            File srcDirectory;
            MavenProject project = pconfig.getMavenProject();
            String outputDirectory = pconfig.getOutputDirectory();
            String outputFileName = pconfig.getOutputFileName();
            File webappDir = new File(outputDirectory + "/" + outputFileName);
            if (!webappDir.exists()) {
                webappDir.mkdirs();
            }
            if (!(srcDirectory = new File(project.getBasedir() + "/src/java")).exists()) {
                return;
            }
            File destVelocityDir = new File(webappDir.getPath() + "/velocity");
            File destGroovyDir = new File(webappDir.getPath() + "/groovy");
            int denum = ProjectUtils.deployResourceFiles(srcDirectory, destVelocityDir, pconfig.getIgnoredFiles(), ProjectUtils.velocityFiles());
            if (denum > 0) {
                ProjectUtils.printMessage("info", "Copied " + denum + " file to directory " + destVelocityDir + ".");
            }
            if ((groovyCounter = ProjectUtils.deployResourceFiles(srcDirectory, destGroovyDir, pconfig.getIgnoredFiles(), ProjectUtils.groovyFiles())) > 0) {
                ProjectUtils.printMessage("info", "Copied " + groovyCounter + " file to directory " + destGroovyDir + ".");
            }
        }
    }

    static class CopyBPARDependency
    extends PackagingCommand {
        CopyBPARDependency() {
        }

        public void execute(PackagingConfiguration pconfig) throws Exception {
            File bpDest = new File(pconfig.getOutputDirectory() + "/" + pconfig.getOutputFileName() + "/WEB-INF/conf/bp");
            ProjectUtils.printMessage("info", "Copy bpar  projects to " + bpDest.getPath());
            if (!bpDest.exists()) {
                bpDest.mkdirs();
            }
            Set artifacts = pconfig.getMavenProject().getDependencyArtifacts();
            for (Artifact artifact : artifacts) {
                if (!"bpar".equals(artifact.getType())) continue;
                ExoFileUtils.copyFileToDirectory((File)artifact.getFile(), (File)bpDest);
            }
        }
    }

    static class CopyShareDir
    extends PackagingCommand {
        CopyShareDir() {
        }

        public void execute(PackagingConfiguration pconfig) throws Exception {
            String outputDirectory = pconfig.getOutputDirectory();
            String outputFileName = pconfig.getOutputFileName();
            File webappDir = new File(outputDirectory + "/" + outputFileName);
            List<String> shareDirectorys = pconfig.getSharePortalWebappDirs();
            if (shareDirectorys == null) {
                System.out.println("  You do not specify a shared webapp directory.............");
            } else {
                for (String shareDir : shareDirectorys) {
                    File shareDirectory = new File(shareDir);
                    ExoFileUtils.copyDirectoryStructure(shareDirectory, webappDir, pconfig.getIgnoredFiles(), true);
                    ProjectUtils.printMessage("info", "Copy " + shareDirectory.getName() + " directory to " + webappDir.getPath());
                }
            }
        }
    }

    static class CopyWebappJarDependency
    extends PackagingCommand {
        CopyWebappJarDependency() {
        }

        public void execute(PackagingConfiguration pconfig) throws Exception {
            File libDir = new File(pconfig.getOutputDirectory() + "/" + pconfig.getOutputFileName() + "/WEB-INF/lib");
            int counter = 0;
            MavenProject project = pconfig.getMavenProject();
            Set artifacts = project.getArtifacts();
            ArrayList list = new ArrayList();
            list.addAll(artifacts);
            Collections.sort(list);
            for (Artifact da : list) {
                if (!"jar".equals(da.getType())) continue;
                ProjectUtils.copyFileToDirectory((File)da.getFile(), (File)libDir);
                ProjectUtils.printMessage("deploy", "  Deployed file '" + da.getArtifactId() + "' to " + libDir.getPath());
                ++counter;
            }
            if (counter > 0) {
                ProjectUtils.printMessage("deploy", "  DEPLOY : " + counter + " dependencies");
            }
        }
    }

    static class CopyWebappDir
    extends PackagingCommand {
        CopyWebappDir() {
        }

        public void execute(PackagingConfiguration pconfig) throws Exception {
            String outputDirectory = pconfig.getOutputDirectory();
            String outputFileName = pconfig.getOutputFileName();
            File webappDir = new File(outputDirectory + "/" + outputFileName);
            if (!webappDir.exists()) {
                webappDir.mkdirs();
            }
            ExoFileUtils.copyDirectoryStructure(new File(pconfig.getMavenProject().getBasedir() + "/src/webapp"), webappDir, pconfig.getIgnoredFiles(), true);
            ProjectUtils.printMessage("info", "Copy webapp directory to " + webappDir.getPath());
            File classSrc = new File(outputDirectory + "/classes");
            if (classSrc.exists()) {
                File webappClassDir = new File(outputDirectory + "/" + outputFileName + "/WEB-INF/classes");
                if (!webappClassDir.exists()) {
                    webappClassDir.mkdirs();
                }
                ExoFileUtils.copyDirectoryStructure((File)classSrc, (File)webappClassDir);
                ProjectUtils.printMessage("info", "Copy class directory to " + webappClassDir.getPath());
            }
        }
    }
}

