/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.List;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.exoplatform.maven2.plugin.DeployCommand;
import org.exoplatform.maven2.plugin.DeployConfiguration;

public class ExoDeploy
extends AbstractMojo {
    protected MavenProject project;
    private List<DeployConfiguration> deployConfigurations;

    public void execute() throws MojoExecutionException {
        List profiles = this.project.getActiveProfiles();
        Profile serverProfile = null;
        for (int i = 0; i < profiles.size(); ++i) {
            Profile profile = (Profile)profiles.get(i);
            if (!profile.getId().endsWith("-server")) continue;
            serverProfile = profile;
        }
        String selectServer = "tomcat-server";
        if (serverProfile != null) {
            selectServer = serverProfile.getId();
        }
        DeployConfiguration selectedConfig = null;
        System.err.println("=================> " + this.deployConfigurations);
        for (DeployConfiguration dconfig : this.deployConfigurations) {
            if (!selectServer.equals(dconfig.getServerType())) continue;
            selectedConfig = dconfig;
            break;
        }
        selectedConfig.setMavenProject(this.project);
        List<String> scripts = selectedConfig.getScripts();
        try {
            for (String command : scripts) {
                if (command.endsWith(".class")) {
                    String className = command.substring(0, command.indexOf(".class"));
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    DeployCommand commandObject = (DeployCommand)cl.loadClass(className).newInstance();
                    commandObject.execute(selectedConfig);
                    continue;
                }
                Binding binding = new Binding();
                binding.setVariable("deployConfig", (Object)selectedConfig);
                GroovyShell shell = new GroovyShell(binding);
                shell.evaluate(command);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("FALSE", ex);
        }
    }
}

