/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tools.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class TextDocument {
    public static final String CLASS_VERSION = "$Id: TextDocument.java,v 1.1 2004/04/19 03:45:49 hatimk Exp $";
    public static final int DOS_FORMAT = 0;
    public static final int UNIX_FORMAT = 1;
    public static final int MAC_FORMAT = 2;
    public static final int DEFAULT_FORMAT = 0;
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String CRLF = "\r\n";
    private int mDocumentFormat = 0;
    private List mLinesContainer = new ArrayList();

    public TextDocument(String pDocument) throws IOException {
        this.mDocumentFormat = this.determineFormat(pDocument);
        this.initDocument(pDocument);
    }

    public int getDocumentFormat() {
        return this.mDocumentFormat;
    }

    public String getNewLineString() {
        switch (this.mDocumentFormat) {
            case 0: {
                return CRLF;
            }
            case 1: {
                return LF;
            }
            case 2: {
                return CR;
            }
        }
        return CRLF;
    }

    public String getString() {
        StringBuffer sb = new StringBuffer();
        for (Line currentLine : this.mLinesContainer) {
            sb.append(currentLine.getContent());
        }
        return sb.toString();
    }

    public int getOffset1(int pLineNumber, int pColumnNumber) {
        int linenumber = pLineNumber - 1;
        if (linenumber > this.mLinesContainer.size() - 1 || linenumber < 0 || this.mLinesContainer.size() < 1) {
            return -1;
        }
        Line line = (Line)this.mLinesContainer.get(linenumber);
        int max = line.getOffset() + (line.getContent().length() - 1);
        int offset = line.getOffset() + (pColumnNumber - 1);
        return offset > max ? -1 : offset;
    }

    private int determineFormat(String pDocument) {
        int crLoc = pDocument.indexOf(CR);
        if (crLoc == -1) {
            return 1;
        }
        int crlfLoc = pDocument.indexOf(CRLF);
        return crlfLoc == -1 ? 2 : 0;
    }

    private void initDocument(String mDocument) throws IOException {
        String newLine = this.getNewLineString();
        int newLineLength = newLine.length();
        int offset = 0;
        BufferedReader reader = new BufferedReader(new StringReader(mDocument));
        String oneLine = reader.readLine();
        while (oneLine != null) {
            this.mLinesContainer.add(new Line(oneLine + newLine, offset));
            offset += oneLine.length() + newLineLength;
            oneLine = reader.readLine();
        }
        reader.close();
    }

    private class Line {
        private int mOffset;
        private String mContent;

        public Line(String pContent, int pOffest) {
            this.mContent = pContent;
            this.mOffset = pOffest;
        }

        public String getContent() {
            return this.mContent;
        }

        public int getOffset() {
            return this.mOffset;
        }
    }
}

