/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tools.xml.webapp.v23;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.exoplatform.tools.xml.XMLModificationTask;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class WebAppModifyTask
extends XMLModificationTask {
    public static final String CLASS_VERSION = "$Id: WebAppModifyTask.java,v 1.1 2004/04/19 03:45:49 hatimk Exp $";
    private Map mCachedXPaths = new HashMap();
    private Map mCachedXPathsResult = new HashMap();
    protected static final String[] WEBAPP_CHILD_ELEMENTS = new String[]{"icon", "display-name", "description", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping", "session-config", "mime-mapping", "welcome-file-list", "error-page", "taglib", "resource-env-ref", "resource-ref", "security-constraint", "login-config", "security-role", "env-entry", "ejb-ref", "ejb-local-ref"};
    protected static final String[] SERVLET_CHILD_ELEMENTS = new String[]{"icon", "servlet-name", "display-name", "description", "servlet-class", "init-param", "load-on-startup", "run-as", "security-role-ref"};
    protected static final String[] SERVLETMAPPING_CHILD_ELEMENTS = new String[]{"servlet-name", "url-pattern"};

    protected void insertElement(Node pParent, Node pNewNode, String[] pElementDTD) throws JaxenException {
        String elementName = pNewNode.getNodeName();
        Node closestNode = this.getClosestSiblingAccordingToDTD(pParent, elementName, pElementDTD);
        Node parent = pParent;
        Node sibling = null;
        if (closestNode != null) {
            sibling = closestNode.getNextSibling();
        } else if (parent.hasChildNodes()) {
            sibling = parent.getFirstChild();
        }
        if (sibling != null) {
            parent.insertBefore(pNewNode, sibling);
        } else {
            parent.appendChild(pNewNode);
        }
    }

    protected Node getClosestSiblingAccordingToDTD(Node pParent, String pElement, String[] pElementDTD) throws JaxenException {
        Node result = null;
        List siblingList = this.buildResultTableUpToElement(pParent, pElement, pElementDTD);
        if (siblingList == null) {
            return result;
        }
        ListIterator iterator = siblingList.listIterator(siblingList.size());
        while (iterator.hasPrevious()) {
            String elementName = (String)iterator.previous();
            Node siblingNode = (Node)this.mCachedXPathsResult.get(elementName);
            if (siblingNode == null) continue;
            result = siblingNode;
            break;
        }
        return result;
    }

    private List getChildElementNames(String[] pElements) {
        int size = pElements.length;
        ArrayList<String> result = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            result.add(pElements[i]);
        }
        return result;
    }

    private XPath getCachedXPath(String pElementName) throws JaxenException {
        XPath xpath = (XPath)this.mCachedXPaths.get(pElementName);
        if (xpath == null) {
            xpath = new DOMXPath(pElementName + "[last()]");
        }
        this.mCachedXPaths.put(pElementName, xpath);
        return xpath;
    }

    private List buildResultTableUpToElement(Node pParent, String pElementName, String[] pElementDTD) throws JaxenException {
        ArrayList<String> result = new ArrayList<String>();
        List all = this.getChildElementNames(pElementDTD);
        int index = all.indexOf(pElementName);
        if (index < 0) {
            return result;
        }
        List sublist = all.subList(0, index);
        for (String elementName : sublist) {
            XPath xpath = this.getCachedXPath(elementName);
            this.mCachedXPathsResult.put(elementName, xpath.selectSingleNode((Object)pParent));
            result.add(elementName);
        }
        return result;
    }

    protected Node getWebAppNode(Document pDoc) throws JaxenException {
        Node result = null;
        DOMXPath webappXPath = new DOMXPath("/web-app");
        result = (Node)webappXPath.selectSingleNode((Object)pDoc);
        return result;
    }
}

