/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jar;

import java.io.File;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public abstract class AbstractJarMojo
extends AbstractMojo {
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/package.html"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private String[] includes;
    private String[] excludes;
    private File outputDirectory;
    private String finalName;
    private JarArchiver jarArchiver;
    private MavenProject project;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private MavenProjectHelper projectHelper;
    private boolean forceCreation;

    protected abstract File getClassesDirectory();

    protected final MavenProject getProject() {
        return this.project;
    }

    protected abstract String getClassifier();

    protected abstract String getType();

    protected static File getJarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, String.valueOf(finalName) + classifier + ".jar");
    }

    public File createArchive() throws MojoExecutionException {
        File jarFile = AbstractJarMojo.getJarFile(this.outputDirectory, this.finalName, this.getClassifier());
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        this.archive.setForced(this.forceCreation);
        try {
            File contentDirectory = this.getClassesDirectory();
            if (!contentDirectory.exists()) {
                this.getLog().warn((CharSequence)"JAR will be empty - no content was marked for inclusion!");
            } else {
                archiver.getArchiver().addDirectory(contentDirectory, this.getIncludes(), this.getExcludes());
            }
            archiver.createArchive(this.project, this.archive);
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling JAR", e);
        }
    }

    public void execute() throws MojoExecutionException {
        File jarFile = this.createArchive();
        String classifier = this.getClassifier();
        if (classifier != null) {
            this.projectHelper.attachArtifact(this.getProject(), this.getType(), classifier, jarFile);
        } else {
            this.getProject().getArtifact().setFile(jarFile);
        }
    }

    private String[] getIncludes() {
        if (this.includes != null && this.includes.length > 0) {
            return this.includes;
        }
        return DEFAULT_INCLUDES;
    }

    private String[] getExcludes() {
        if (this.excludes != null && this.excludes.length > 0) {
            return this.excludes;
        }
        return DEFAULT_EXCLUDES;
    }
}

